/*
 * Decompiled with CFR 0.152.
 */
package com.ns.yc.yccustomtextlib.edit.view;

import android.animation.LayoutTransition;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import com.ns.yc.yccustomtextlib.R;
import com.ns.yc.yccustomtextlib.edit.inter.OnHyperChangeListener;
import com.ns.yc.yccustomtextlib.edit.inter.OnHyperEditListener;
import com.ns.yc.yccustomtextlib.edit.manager.HyperManager;
import com.ns.yc.yccustomtextlib.edit.model.HyperEditData;
import com.ns.yc.yccustomtextlib.edit.span.SpanTextHelper;
import com.ns.yc.yccustomtextlib.edit.state.TextEditorState;
import com.ns.yc.yccustomtextlib.edit.view.DeletableEditText;
import com.ns.yc.yccustomtextlib.edit.view.HyperImageView;
import com.ns.yc.yccustomtextlib.utils.HyperLibUtils;
import com.ns.yc.yccustomtextlib.utils.HyperLogUtils;
import java.util.ArrayList;
import java.util.List;

public class HyperTextEditor
extends ScrollView {
    private static final int EDIT_PADDING = 10;
    private int viewTagIndex = 1;
    private LinearLayout layout;
    private LayoutInflater inflater;
    private View.OnKeyListener keyListener;
    private View.OnClickListener btnListener;
    private View.OnFocusChangeListener focusListener;
    private TextWatcher textWatcher;
    private EditText lastFocusEdit;
    private LayoutTransition mTransition;
    private int editNormalPadding = 0;
    private int disappearingImageIndex = 0;
    private ArrayList<String> imagePaths;
    private String keywords;
    private int rtImageHeight;
    private int topAndBottom;
    private int leftAndRight;
    private int rtImageBottom = 10;
    private String rtTextInitHint = "\u8bf7\u8f93\u5165\u5185\u5bb9";
    private int rtTextSize = 16;
    private int rtTextColor = Color.parseColor((String)"#757575");
    private int rtTextLineSpace = 8;
    private int contentLength = 0;
    private int imageLength = 0;
    private OnHyperEditListener onHyperListener;
    private OnHyperChangeListener onHyperChangeListener;
    private LayoutTransition.TransitionListener transitionListener = new LayoutTransition.TransitionListener(){

        public void startTransition(LayoutTransition transition, ViewGroup container, View view, int transitionType) {
        }

        public void endTransition(LayoutTransition transition, ViewGroup container, View view, int transitionType) {
            if (!transition.isRunning() && transitionType == 1) {
                HyperTextEditor.this.mergeEditText();
            }
        }
    };

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        TextEditorState viewState = new TextEditorState(superState);
        viewState.rtImageHeight = this.rtImageHeight;
        return viewState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        TextEditorState viewState = (TextEditorState)state;
        this.rtImageHeight = viewState.rtImageHeight;
        super.onRestoreInstanceState(viewState.getSuperState());
        this.requestLayout();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mTransition != null) {
            this.mTransition.removeTransitionListener(this.transitionListener);
            HyperLogUtils.d("HyperTextEditor----onDetachedFromWindow------\u79fb\u9664Layout\u53d8\u5316\u76d1\u542c");
        }
    }

    public HyperTextEditor(Context context) {
        this(context, null);
    }

    public HyperTextEditor(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HyperTextEditor(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.imagePaths = new ArrayList();
        this.inflater = LayoutInflater.from((Context)context);
        this.initAttrs(context, attrs);
        this.initLayoutView(context);
        this.initListener();
        this.initFirstEditText(context);
    }

    private void initLayoutView(Context context) {
        this.layout = new LinearLayout(context);
        this.layout.setOrientation(1);
        this.setUpLayoutTransitions();
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        this.layout.setPadding(this.leftAndRight, this.topAndBottom, this.leftAndRight, this.topAndBottom);
        this.addView((View)this.layout, (ViewGroup.LayoutParams)layoutParams);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.HyperTextEditor);
        this.topAndBottom = ta.getInteger(R.styleable.HyperTextEditor_editor_layout_top_bottom, 15);
        this.leftAndRight = ta.getInteger(R.styleable.HyperTextEditor_editor_layout_right_left, 40);
        this.rtImageHeight = ta.getInteger(R.styleable.HyperTextEditor_editor_image_height, 500);
        this.rtImageBottom = ta.getInteger(R.styleable.HyperTextEditor_editor_image_bottom, 10);
        this.rtTextSize = ta.getDimensionPixelSize(R.styleable.HyperTextEditor_editor_text_size, 16);
        this.rtTextLineSpace = ta.getDimensionPixelSize(R.styleable.HyperTextEditor_editor_text_line_space, 8);
        this.rtTextColor = ta.getColor(R.styleable.HyperTextEditor_editor_text_color, Color.parseColor((String)"#757575"));
        this.rtTextInitHint = ta.getString(R.styleable.HyperTextEditor_editor_text_init_hint);
        ta.recycle();
    }

    private void initListener() {
        this.keyListener = new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == 0 && event.getKeyCode() == 67) {
                    EditText edit = (EditText)v;
                    HyperTextEditor.this.onBackspacePress(edit);
                }
                return false;
            }
        };
        this.btnListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (v instanceof HyperImageView) {
                    HyperImageView imageView = (HyperImageView)v;
                    if (HyperTextEditor.this.onHyperListener != null) {
                        HyperTextEditor.this.onHyperListener.onImageClick((View)imageView, imageView.getAbsolutePath());
                    }
                } else if (v instanceof ImageView) {
                    RelativeLayout parentView = (RelativeLayout)v.getParent();
                    HyperTextEditor.this.onImageCloseClick((View)parentView);
                }
            }
        };
        this.focusListener = new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    HyperTextEditor.this.lastFocusEdit = (EditText)v;
                    HyperLogUtils.d("HyperTextEditor---onFocusChange--" + HyperTextEditor.this.lastFocusEdit);
                }
            }
        };
        this.textWatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                HyperTextEditor.this.addHyperEditorChangeListener();
                HyperLogUtils.d("HyperTextEditor---onTextChanged--\u6587\u5b57--" + HyperTextEditor.this.contentLength + "--\u56fe\u7247-" + HyperTextEditor.this.imageLength);
            }

            public void afterTextChanged(Editable s) {
            }
        };
    }

    private void initFirstEditText(Context context) {
        LinearLayout.LayoutParams firstEditParam = new LinearLayout.LayoutParams(-1, -1);
        int padding = HyperLibUtils.dip2px(context, 10.0f);
        EditText firstEdit = this.createEditText(this.rtTextInitHint, padding);
        this.layout.addView((View)firstEdit, (ViewGroup.LayoutParams)firstEditParam);
        this.lastFocusEdit = firstEdit;
    }

    @SuppressLint(value={"SetTextI18n"})
    private void onBackspacePress(EditText editText) {
        try {
            int startSelection = editText.getSelectionStart();
            if (startSelection == 0) {
                int editIndex = this.layout.indexOfChild((View)editText);
                View preView = this.layout.getChildAt(editIndex - 1);
                if (null != preView) {
                    if (preView instanceof RelativeLayout) {
                        this.onImageCloseClick(preView);
                    } else if (preView instanceof EditText) {
                        String str1 = editText.getText().toString();
                        EditText preEdit = (EditText)preView;
                        String str2 = preEdit.getText().toString();
                        this.layout.setLayoutTransition(null);
                        this.layout.removeView((View)editText);
                        this.layout.setLayoutTransition(this.mTransition);
                        preEdit.setText((CharSequence)(str2 + str1));
                        preEdit.requestFocus();
                        preEdit.setSelection(str2.length(), str2.length());
                        this.lastFocusEdit = preEdit;
                    }
                } else {
                    HyperLogUtils.d("HyperTextEditor----onBackspacePress------\u6ca1\u6709\u4e0a\u4e00\u4e2aview");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onImageCloseClick(View view) {
        try {
            if (!this.mTransition.isRunning()) {
                this.disappearingImageIndex = this.layout.indexOfChild(view);
                List<HyperEditData> dataList = this.buildEditData();
                HyperEditData editData = dataList.get(this.disappearingImageIndex);
                if (editData.getImagePath() != null) {
                    if (this.onHyperListener != null) {
                        this.onHyperListener.onRtImageDelete(editData.getImagePath());
                    }
                    this.imagePaths.remove(editData.getImagePath());
                    this.addHyperEditorChangeListener();
                }
                this.layout.removeView(view);
                this.mergeEditText();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addHyperEditorChangeListener() {
        this.getContentAndImageCount();
        int contentLength = this.getContentLength();
        int imageLength = this.getImageLength();
        if (this.onHyperChangeListener != null) {
            this.onHyperChangeListener.onImageClick(contentLength, imageLength);
        }
    }

    public void clearAllLayout() {
        if (this.layout != null) {
            this.layout.removeAllViews();
        }
    }

    public int getLastIndex() {
        if (this.layout != null) {
            int childCount = this.layout.getChildCount();
            return childCount;
        }
        return -1;
    }

    public EditText createEditText(String hint, int paddingTop) {
        DeletableEditText editText = new DeletableEditText(this.getContext());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        editText.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        editText.setTextSize(16.0f);
        editText.setTextColor(Color.parseColor((String)"#616161"));
        editText.setCursorVisible(true);
        editText.setBackground(null);
        editText.setOnKeyListener(this.keyListener);
        editText.setOnFocusChangeListener(this.focusListener);
        editText.addTextChangedListener(this.textWatcher);
        editText.setTag(this.viewTagIndex++);
        editText.setPadding(this.editNormalPadding, paddingTop, this.editNormalPadding, paddingTop);
        editText.setHint(hint);
        editText.setTextSize(0, this.rtTextSize);
        editText.setTextColor(this.rtTextColor);
        editText.setLineSpacing(this.rtTextLineSpace, 1.0f);
        return editText;
    }

    private RelativeLayout createImageLayout() {
        RelativeLayout layout2 = (RelativeLayout)this.inflater.inflate(R.layout.edit_imageview, null);
        layout2.setTag((Object)this.viewTagIndex++);
        View closeView = layout2.findViewById(R.id.image_close);
        closeView.setTag(layout2.getTag());
        closeView.setOnClickListener(this.btnListener);
        HyperImageView imageView = (HyperImageView)layout2.findViewById(R.id.edit_imageView);
        imageView.setOnClickListener(this.btnListener);
        return layout2;
    }

    public void insertImage(String imagePath) {
        if (TextUtils.isEmpty((CharSequence)imagePath)) {
            return;
        }
        try {
            String lastEditStr = this.lastFocusEdit.getText().toString();
            int cursorIndex = this.lastFocusEdit.getSelectionStart();
            String editStr1 = lastEditStr.substring(0, cursorIndex).trim();
            String editStr2 = lastEditStr.substring(cursorIndex).trim();
            int lastEditIndex = this.layout.indexOfChild((View)this.lastFocusEdit);
            if (lastEditStr.length() == 0) {
                this.addEditTextAtIndex(lastEditIndex + 1, "");
                this.addImageViewAtIndex(lastEditIndex + 1, imagePath);
            } else if (editStr1.length() == 0) {
                this.addImageViewAtIndex(lastEditIndex, imagePath);
                this.addEditTextAtIndex(lastEditIndex + 1, "");
            } else if (editStr2.length() == 0) {
                this.addEditTextAtIndex(lastEditIndex + 1, "");
                this.addImageViewAtIndex(lastEditIndex + 1, imagePath);
            } else {
                this.lastFocusEdit.setText((CharSequence)editStr1);
                this.addEditTextAtIndex(lastEditIndex + 1, editStr2);
                this.addEditTextAtIndex(lastEditIndex + 1, "");
                this.addImageViewAtIndex(lastEditIndex + 1, imagePath);
            }
            this.hideKeyBoard();
            this.addHyperEditorChangeListener();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hideKeyBoard() {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (imm != null && this.lastFocusEdit != null) {
            imm.hideSoftInputFromWindow(this.lastFocusEdit.getWindowToken(), 0);
        }
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public void addEditTextAtIndex(int index, CharSequence editStr) {
        try {
            EditText editText = this.createEditText("\u63d2\u5165\u6587\u5b57", 10);
            if (!TextUtils.isEmpty((CharSequence)this.keywords)) {
                SpannableStringBuilder textStr = HyperLibUtils.highlight(editStr.toString(), this.keywords, Color.parseColor((String)"#EE5C42"));
                editText.setText((CharSequence)textStr);
            } else if (!TextUtils.isEmpty((CharSequence)editStr)) {
                editText.setText(editStr);
            }
            this.layout.setLayoutTransition(null);
            this.layout.addView((View)editText, index);
            this.layout.setLayoutTransition(this.mTransition);
            this.lastFocusEdit = editText;
            this.lastFocusEdit.requestFocus();
            this.lastFocusEdit.setSelection(editStr.length(), editStr.length());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addImageViewAtIndex(int index, String imagePath) {
        if (TextUtils.isEmpty((CharSequence)imagePath)) {
            return;
        }
        try {
            this.imagePaths.add(imagePath);
            RelativeLayout imageLayout = this.createImageLayout();
            HyperImageView imageView = (HyperImageView)imageLayout.findViewById(R.id.edit_imageView);
            imageView.setAbsolutePath(imagePath);
            HyperManager.getInstance().loadImage(imagePath, (ImageView)imageView, this.rtImageHeight);
            this.layout.addView((View)imageLayout, index);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setUpLayoutTransitions() {
        this.mTransition = new LayoutTransition();
        this.mTransition.addTransitionListener(this.transitionListener);
        this.mTransition.enableTransitionType(2);
        this.mTransition.setDuration(300L);
        this.layout.setLayoutTransition(this.mTransition);
    }

    private void mergeEditText() {
        try {
            View preView = this.layout.getChildAt(this.disappearingImageIndex - 1);
            View nextView = this.layout.getChildAt(this.disappearingImageIndex);
            if (preView instanceof EditText && nextView instanceof EditText) {
                EditText preEdit = (EditText)preView;
                EditText nextEdit = (EditText)nextView;
                String str1 = preEdit.getText().toString();
                String str2 = nextEdit.getText().toString();
                String mergeText = "";
                mergeText = str2.length() > 0 ? str1 + "\n" + str2 : str1;
                this.layout.setLayoutTransition(null);
                this.layout.removeView((View)nextEdit);
                preEdit.setText((CharSequence)mergeText);
                preEdit.requestFocus();
                preEdit.setSelection(str1.length(), str1.length());
                this.layout.setLayoutTransition(this.mTransition);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<HyperEditData> buildEditData() {
        ArrayList<HyperEditData> dataList = new ArrayList<HyperEditData>();
        try {
            int num = this.layout.getChildCount();
            for (int index = 0; index < num; ++index) {
                Object item;
                View itemView = this.layout.getChildAt(index);
                HyperEditData hyperEditData = new HyperEditData();
                if (itemView instanceof EditText) {
                    item = (EditText)itemView;
                    hyperEditData.setInputStr(item.getText().toString());
                    hyperEditData.setType(1);
                } else if (itemView instanceof RelativeLayout) {
                    item = (HyperImageView)itemView.findViewById(R.id.edit_imageView);
                    hyperEditData.setImagePath(((HyperImageView)((Object)item)).getAbsolutePath());
                    hyperEditData.setType(2);
                }
                dataList.add(hyperEditData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HyperLogUtils.d("HyperTextEditor----buildEditData------dataList---" + dataList.size());
        return dataList;
    }

    public void getContentAndImageCount() {
        this.contentLength = 0;
        this.imageLength = 0;
        if (this.layout == null) {
            return;
        }
        try {
            int num = this.layout.getChildCount();
            for (int index = 0; index < num; ++index) {
                View itemView = this.layout.getChildAt(index);
                if (itemView instanceof EditText) {
                    EditText item = (EditText)itemView;
                    String string = item.getText().toString().trim();
                    int length = string.length();
                    this.contentLength += length;
                    continue;
                }
                if (!(itemView instanceof RelativeLayout)) continue;
                ++this.imageLength;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HyperLogUtils.d("HyperTextEditor----buildEditData------dataList---");
    }

    public void setOnHyperListener(OnHyperEditListener listener) {
        this.onHyperListener = listener;
    }

    public void setOnHyperChangeListener(OnHyperChangeListener onHyperChangeListener) {
        this.onHyperChangeListener = onHyperChangeListener;
    }

    public EditText getLastFocusEdit() {
        return this.lastFocusEdit;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public int getImageLength() {
        return this.imageLength;
    }

    public void bold() {
        SpanTextHelper.getInstance().bold(this.lastFocusEdit);
    }

    public void italic() {
        SpanTextHelper.getInstance().italic(this.lastFocusEdit);
    }

    public void boldItalic() {
        SpanTextHelper.getInstance().boldItalic(this.lastFocusEdit);
    }

    public void strikeThrough() {
        SpanTextHelper.getInstance().strikeThrough(this.lastFocusEdit);
    }

    public void underline() {
        SpanTextHelper.getInstance().underline(this.lastFocusEdit);
    }
}

