/*
 * Decompiled with CFR 0.152.
 */
package com.ns.yc.yccustomtextlib.hyper;

import android.animation.LayoutTransition;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import com.bumptech.glide.Glide;
import com.ns.yc.yccustomtextlib.R;
import com.ns.yc.yccustomtextlib.hyper.HyperImageView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class HyperTextEditor
extends ScrollView {
    private static final int EDIT_PADDING = 10;
    private int viewTagIndex = 1;
    private LinearLayout allLayout;
    private LayoutInflater inflater;
    private View.OnKeyListener keyListener;
    private View.OnClickListener btnListener;
    private View.OnFocusChangeListener focusListener;
    private EditText lastFocusEdit;

    public HyperTextEditor(Context context) {
        this(context, null);
    }

    public HyperTextEditor(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HyperTextEditor(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.inflater = LayoutInflater.from((Context)context);
        this.allLayout = new LinearLayout(context);
        this.allLayout.setOrientation(1);
        this.setupLayoutTransitions();
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        this.allLayout.setPadding(HyperTextEditor.dp2px(context, 10.0f), HyperTextEditor.dp2px(context, 15.0f), HyperTextEditor.dp2px(context, 10.0f), HyperTextEditor.dp2px(context, 15.0f));
        this.addView((View)this.allLayout, (ViewGroup.LayoutParams)layoutParams);
        this.keyListener = new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == 0 && event.getKeyCode() == 67) {
                    EditText edit = (EditText)v;
                    HyperTextEditor.this.onBackspacePress(edit);
                }
                return false;
            }
        };
        this.btnListener = new View.OnClickListener(){

            public void onClick(View v) {
                RelativeLayout parentView = (RelativeLayout)v.getParent();
                HyperTextEditor.this.onImageCloseClick((View)parentView);
            }
        };
        this.focusListener = new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    HyperTextEditor.this.lastFocusEdit = (EditText)v;
                }
            }
        };
        LinearLayout.LayoutParams firstEditParam = new LinearLayout.LayoutParams(-1, -1);
        EditText firstEdit = this.createEditText("\u8bf7\u8f93\u5165\u5185\u5bb9", this.dip2px(context, 10.0f));
        this.allLayout.addView((View)firstEdit, (ViewGroup.LayoutParams)firstEditParam);
        this.lastFocusEdit = firstEdit;
    }

    private void setupLayoutTransitions() {
        LayoutTransition transition = new LayoutTransition();
        this.allLayout.setLayoutTransition(transition);
        transition.addTransitionListener(new LayoutTransition.TransitionListener(){

            public void startTransition(LayoutTransition transition, ViewGroup container, View view, int transitionType) {
            }

            public void endTransition(LayoutTransition transition, ViewGroup container, View view, int transitionType) {
                if (transition.isRunning() || transitionType == 1) {
                    // empty if block
                }
            }
        });
        transition.setDuration(300L);
    }

    public int dip2px(Context context, float dipValue) {
        float m = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * m + 0.5f);
    }

    private void onBackspacePress(EditText editTxt) {
        int editIndex;
        View preView;
        int startSelection = editTxt.getSelectionStart();
        if (startSelection == 0 && null != (preView = this.allLayout.getChildAt((editIndex = this.allLayout.indexOfChild((View)editTxt)) - 1))) {
            if (preView instanceof RelativeLayout) {
                this.onImageCloseClick(preView);
            } else if (preView instanceof EditText) {
                String str1 = editTxt.getText().toString();
                EditText preEdit = (EditText)preView;
                String str2 = preEdit.getText().toString();
                this.allLayout.removeView((View)editTxt);
                StringBuilder sb = new StringBuilder();
                sb.append(str2);
                sb.append(str1);
                preEdit.setText((CharSequence)sb.toString());
                preEdit.requestFocus();
                preEdit.setSelection(str2.length(), str2.length());
                this.lastFocusEdit = preEdit;
            }
        }
    }

    private void onImageCloseClick(View view) {
        int disappearingImageIndex = this.allLayout.indexOfChild(view);
        List<EditData> dataList = this.buildEditData();
        EditData editData = dataList.get(disappearingImageIndex);
        if (editData.imagePath != null) {
            this.deleteFile(editData.imagePath);
        }
        this.allLayout.removeView(view);
    }

    public void clearAllLayout() {
        this.allLayout.removeAllViews();
    }

    public int getLastIndex() {
        return this.allLayout.getChildCount();
    }

    public EditText createEditText(String hint, int paddingTop) {
        EditText editText = (EditText)this.inflater.inflate(R.layout.hyper_edit_text, null);
        editText.setOnKeyListener(this.keyListener);
        editText.setTag((Object)this.viewTagIndex++);
        editText.setPadding(0, paddingTop, 0, paddingTop);
        editText.setHint((CharSequence)hint);
        editText.setOnFocusChangeListener(this.focusListener);
        return editText;
    }

    private RelativeLayout createImageLayout() {
        RelativeLayout layout2 = (RelativeLayout)this.inflater.inflate(R.layout.edit_image_view, null);
        layout2.setTag((Object)this.viewTagIndex++);
        View closeView = layout2.findViewById(R.id.image_close);
        closeView.setTag(layout2.getTag());
        closeView.setOnClickListener(this.btnListener);
        return layout2;
    }

    public void insertImage(String imagePath, int width) {
        Bitmap bmp = this.getScaledBitmap(imagePath, width);
        this.insertImage(bmp, imagePath);
    }

    public void insertImage(Bitmap bitmap, String imagePath) {
        String lastEditStr = this.lastFocusEdit.getText().toString();
        int cursorIndex = this.lastFocusEdit.getSelectionStart();
        String editStr1 = lastEditStr.substring(0, cursorIndex).trim();
        int lastEditIndex = this.allLayout.indexOfChild((View)this.lastFocusEdit);
        if (lastEditStr.length() == 0 || editStr1.length() == 0) {
            this.addImageViewAtIndex(lastEditIndex, imagePath);
        } else {
            this.lastFocusEdit.setText((CharSequence)editStr1);
            String editStr2 = lastEditStr.substring(cursorIndex).trim();
            if (editStr2.length() == 0) {
                editStr2 = " ";
            }
            if (this.allLayout.getChildCount() - 1 == lastEditIndex) {
                this.addEditTextAtIndex(lastEditIndex + 1, editStr2);
            }
            this.addImageViewAtIndex(lastEditIndex + 1, imagePath);
            this.lastFocusEdit.requestFocus();
            this.lastFocusEdit.setSelection(editStr1.length(), editStr1.length());
        }
        this.hideKeyBoard();
    }

    public void hideKeyBoard() {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.lastFocusEdit.getWindowToken(), 0);
    }

    public void addEditTextAtIndex(int index, CharSequence editStr) {
        EditText editText2 = this.createEditText("", 10);
        editText2.setText(editStr);
        editText2.setOnFocusChangeListener(this.focusListener);
        this.allLayout.addView((View)editText2, index);
    }

    public void addImageViewAtIndex(int index, String imagePath) {
        RelativeLayout imageLayout = this.createImageLayout();
        HyperImageView imageView = (HyperImageView)imageLayout.findViewById(R.id.edit_imageView);
        Glide.with((Context)this.getContext()).load(imagePath).crossFade().centerCrop().into((ImageView)imageView);
        imageView.setAbsolutePath(imagePath);
        imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        Bitmap bmp = BitmapFactory.decodeFile((String)imagePath);
        int imageHeight = 500;
        if (bmp != null) {
            imageHeight = this.allLayout.getWidth() * bmp.getHeight() / bmp.getWidth();
            bmp.recycle();
        }
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, imageHeight);
        lp.bottomMargin = 10;
        imageView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.allLayout.addView((View)imageLayout, index);
    }

    public Bitmap getScaledBitmap(String filePath, int width) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        int sampleSize = options.outWidth > width ? options.outWidth / width + 1 : 1;
        options.inJustDecodeBounds = false;
        options.inSampleSize = sampleSize;
        return BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
    }

    public List<EditData> buildEditData() {
        ArrayList<EditData> dataList = new ArrayList<EditData>();
        int num = this.allLayout.getChildCount();
        for (int index = 0; index < num; ++index) {
            Object item;
            View itemView = this.allLayout.getChildAt(index);
            EditData itemData = new EditData();
            if (itemView instanceof EditText) {
                item = (EditText)itemView;
                itemData.inputStr = item.getText().toString();
            } else if (itemView instanceof RelativeLayout) {
                item = (HyperImageView)itemView.findViewById(R.id.edit_imageView);
                itemData.imagePath = ((HyperImageView)((Object)item)).getAbsolutePath();
            }
            dataList.add(itemData);
        }
        return dataList;
    }

    public void deleteFile(String filePath) {
        if (filePath == null) {
            return;
        }
        File file = new File(filePath);
        if (file.isFile() && file.exists()) {
            file.delete();
        }
    }

    public static int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public class EditData {
        public String inputStr;
        public String imagePath;
    }
}

