/*
 * Decompiled with CFR 0.152.
 */
package com.yc.m3u8.manager;

import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.yc.m3u8.bean.M3u8;
import com.yc.m3u8.bean.M3u8Ts;
import com.yc.m3u8.inter.M3U8Listener;
import com.yc.m3u8.utils.M3u8FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.IOUtils;

public class M3u8Manger {
    private static int currDownloadTsCount = 0;
    private static final int WHAT_ON_START = 166;
    private static final int WHAT_ON_ERROR = 711;
    private static final int WHAT_ON_GETINFO = 840;
    private static final int WHAT_ON_COMPLITED = 625;
    private static final int WHAT_ON_PROGRESS = 280;
    private static final int WHAT_ON_FILESIZE_ITEM = 281;
    private static final String KEY_DEFAULT_TEMP_DIR = "/sdcard/1m3u8temp/";
    private static M3u8Manger mM3U8Manger;
    private String url;
    private String saveFilePath = "/sdcard/Movie/" + System.currentTimeMillis() + ".ts";
    private String tempDir = "/sdcard/1m3u8temp/";
    private ExecutorService executor;
    private M3U8Listener downLoadListener;
    private boolean isRunning = false;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (M3u8Manger.this.downLoadListener != null) {
                switch (msg.what) {
                    case 166: {
                        M3u8Manger.this.downLoadListener.onStart();
                        break;
                    }
                    case 711: {
                        M3u8Manger.this.isRunning = false;
                        currDownloadTsCount = 0;
                        M3u8FileUtils.clearDir(new File(M3u8Manger.this.tempDir));
                        M3u8Manger.this.downLoadListener.onError((Throwable)msg.obj);
                        break;
                    }
                    case 840: {
                        M3u8 m3U8 = (M3u8)msg.obj;
                        M3u8Manger.this.downLoadListener.onM3U8Info(m3U8);
                        break;
                    }
                    case 625: {
                        currDownloadTsCount = 0;
                        M3u8Manger.this.downLoadListener.onCompleted();
                        break;
                    }
                    case 281: {
                        M3u8Manger.this.downLoadListener.onLoadFileSizeForItem((Long)msg.obj);
                        break;
                    }
                    case 280: {
                        long curTime = System.currentTimeMillis();
                        M3u8Manger.this.lastTime = curTime;
                        M3u8Manger.this.downLoadListener.onDownloadingProgress(msg.arg1, msg.arg2);
                    }
                }
            }
        }
    };
    private long lastTime = 0L;

    private M3u8Manger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static M3u8Manger getInstance() {
        Class<M3u8Manger> clazz = M3u8Manger.class;
        synchronized (M3u8Manger.class) {
            if (mM3U8Manger == null) {
                mM3U8Manger = new M3u8Manger();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mM3U8Manger;
        }
    }

    public synchronized void download(M3U8Listener downLoadListener) {
        this.downLoadListener = downLoadListener;
        if (Environment.getExternalStorageState().equals("mounted")) {
            if (!this.isRunning) {
                this.startDownload(-1L, -1L);
            } else {
                this.handlerError(new Throwable("Task isRunning"));
            }
        } else {
            this.handlerError(new Throwable("SDcard not found"));
        }
    }

    public synchronized boolean isRunning() {
        return this.isRunning;
    }

    public synchronized void download(long startDwonloadTime, long endDownloadTime, M3U8Listener downLoadListener) {
        this.downLoadListener = downLoadListener;
        if (Environment.getExternalStorageState().equals("mounted")) {
            if (!this.isRunning) {
                this.startDownload(startDwonloadTime, endDownloadTime);
            } else {
                this.handlerError(new Throwable("Task isRunning"));
            }
        } else {
            this.handlerError(new Throwable("SDcard not found"));
        }
    }

    public synchronized void stop() {
        this.isRunning = false;
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
            M3u8FileUtils.clearDir(new File(this.tempDir));
        }
    }

    public synchronized void getM3U8(M3U8Listener downLoadListener) {
        this.downLoadListener = downLoadListener;
        downLoadListener.onStart();
        if (!this.isRunning) {
            new Thread(){

                @Override
                public void run() {
                    M3u8Manger.this.isRunning = true;
                    try {
                        M3u8 m3u8 = M3u8FileUtils.parseIndex(M3u8Manger.this.url);
                        M3u8Manger.this.isRunning = false;
                        M3u8Manger.this.sendM3u8Info(m3u8);
                        M3u8Manger.this.mHandler.sendEmptyMessage(625);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        M3u8Manger.this.handlerError(e);
                    }
                }
            }.start();
        } else {
            this.handlerError(new Throwable("Task isRunning"));
        }
    }

    private synchronized void startDownload(final long startDwonloadTime, final long endDownloadTime) {
        this.mHandler.sendEmptyMessage(166);
        this.isRunning = true;
        new Thread(){

            @Override
            public void run() {
                try {
                    M3u8 m3u8 = null;
                    try {
                        m3u8 = M3u8FileUtils.parseIndex(M3u8Manger.this.url);
                        m3u8.setStartDownloadTime(startDwonloadTime);
                        m3u8.setEndDownloadTime(endDownloadTime);
                        M3u8Manger.this.sendM3u8Info(m3u8);
                    }
                    catch (Exception e) {
                        M3u8Manger.this.handlerError(e);
                        M3u8FileUtils.clearDir(new File(M3u8Manger.this.tempDir));
                        return;
                    }
                    if (M3u8Manger.this.executor != null && M3u8Manger.this.executor.isTerminated()) {
                        M3u8Manger.this.executor.shutdownNow();
                        M3u8Manger.this.executor = null;
                    }
                    M3u8Manger.this.executor = Executors.newFixedThreadPool(10);
                    if (M3u8Manger.this.isRunning()) {
                        M3u8Manger.this.download(m3u8, M3u8Manger.this.tempDir);
                    }
                    if (M3u8Manger.this.executor != null) {
                        M3u8Manger.this.executor.shutdown();
                    }
                    while (M3u8Manger.this.executor != null && !M3u8Manger.this.executor.isTerminated()) {
                        Thread.sleep(100L);
                    }
                    if (M3u8Manger.this.isRunning()) {
                        String tempFile = M3u8Manger.this.tempDir + "/" + System.currentTimeMillis() + ".ts";
                        M3u8FileUtils.merge(m3u8, tempFile);
                        M3u8FileUtils.moveFile(tempFile, M3u8Manger.this.saveFilePath);
                        M3u8Manger.this.mHandler.sendEmptyMessage(625);
                        M3u8Manger.this.isRunning = false;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    M3u8Manger.this.handlerError(e);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    M3u8Manger.this.handlerError(e);
                }
                finally {
                    M3u8FileUtils.clearDir(new File(M3u8Manger.this.tempDir));
                }
            }
        }.start();
    }

    private void sendM3u8Info(M3u8 m3u8) {
        Message msg = this.mHandler.obtainMessage();
        msg.obj = m3u8;
        msg.what = 840;
        this.mHandler.sendMessage(msg);
    }

    private void handlerError(Throwable e) {
        Message msg = this.mHandler.obtainMessage();
        msg.obj = e;
        msg.what = 711;
        this.mHandler.sendMessage(msg);
    }

    public synchronized M3u8Manger setUrl(String url) {
        this.url = url;
        return this;
    }

    public synchronized M3u8Manger setSaveFilePath(String saveFilePath) {
        this.saveFilePath = saveFilePath;
        this.tempDir = KEY_DEFAULT_TEMP_DIR;
        return this;
    }

    private void download(final M3u8 m3u8, String saveFileName) throws IOException {
        Log.e((String)"hdltag", (String)("caching(M3U8Manger.java:293):" + saveFileName));
        final File dir = new File(saveFileName);
        if (!dir.exists()) {
            dir.mkdirs();
        } else if (dir.list().length > 0) {
            M3u8FileUtils.clearDir(dir);
        }
        List<M3u8Ts> downList = M3u8FileUtils.getLimitM3U8Ts(m3u8);
        final int total = downList.size();
        for (final M3u8Ts ts : downList) {
            if (this.executor != null && !this.executor.isShutdown()) {
                this.executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block9: {
                            try {
                                if (!M3u8Manger.this.isRunning()) break block9;
                                long size = 0L;
                                try (FileOutputStream writer = null;){
                                    writer = new FileOutputStream(new File(dir, ts.getFileName()));
                                    size = IOUtils.copyLarge((InputStream)new URL(m3u8.getBasepath() + ts.getFileName()).openStream(), (OutputStream)writer);
                                }
                                currDownloadTsCount++;
                                if (currDownloadTsCount == 2) {
                                    long length = new File(dir, ts.getFileName()).length();
                                    Message msg = M3u8Manger.this.mHandler.obtainMessage();
                                    msg.what = 281;
                                    msg.obj = length;
                                    M3u8Manger.this.mHandler.sendMessage(msg);
                                }
                                Message msg = M3u8Manger.this.mHandler.obtainMessage();
                                msg.what = 280;
                                msg.obj = size;
                                msg.arg1 = total;
                                msg.arg2 = currDownloadTsCount;
                                M3u8Manger.this.mHandler.sendMessage(msg);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                M3u8Manger.this.handlerError(e);
                            }
                        }
                    }
                });
                continue;
            }
            this.handlerError(new Throwable("executor is shutdown"));
        }
    }

    public String getNetSpeed() {
        int speed = (int)(Math.random() * 1024.0 + 1.0);
        return speed + " kb/s";
    }

    public String getNetSpeed(int max) {
        int speed = (int)(Math.random() * (double)max + 1.0);
        return speed + " kb/s";
    }
}

