/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videocache.cache;

import android.content.Context;
import com.yc.videocache.HttpProxyCacheServer;
import com.yc.videocache.StorageUtils;
import java.io.File;

public class ProxyVideoCacheManager {
    private static HttpProxyCacheServer sharedProxy;

    private ProxyVideoCacheManager() {
    }

    public static HttpProxyCacheServer getProxy(Context context) {
        return sharedProxy == null ? (sharedProxy = ProxyVideoCacheManager.newProxy(context)) : sharedProxy;
    }

    private static HttpProxyCacheServer newProxy(Context context) {
        return new HttpProxyCacheServer.Builder(context).maxCacheSize(0x20000000L).build();
    }

    public static boolean clearAllCache(Context context) {
        ProxyVideoCacheManager.getProxy(context);
        return StorageUtils.deleteFiles(sharedProxy.getCacheRoot());
    }

    public static boolean clearDefaultCache(Context context, String url) {
        ProxyVideoCacheManager.getProxy(context);
        File pathTmp = sharedProxy.getTempCacheFile(url);
        File path = sharedProxy.getCacheFile(url);
        return StorageUtils.deleteFile(pathTmp.getAbsolutePath()) && StorageUtils.deleteFile(path.getAbsolutePath());
    }
}

