/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videocache.cache;

import android.content.Context;
import com.yc.videocache.HttpProxyCacheServer;
import com.yc.videocache.Logger;
import com.yc.videocache.cache.PreloadTask;
import com.yc.videocache.cache.ProxyVideoCacheManager;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PreloadManager {
    private static PreloadManager sPreloadManager;
    private ExecutorService mExecutorService = Executors.newSingleThreadExecutor();
    private LinkedHashMap<String, PreloadTask> mPreloadTasks = new LinkedHashMap();
    private boolean mIsStartPreload = true;
    private HttpProxyCacheServer mHttpProxyCacheServer;
    public static final int PRELOAD_LENGTH = 524288;

    private PreloadManager(Context context) {
        this.mHttpProxyCacheServer = ProxyVideoCacheManager.getProxy(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PreloadManager getInstance(Context context) {
        if (sPreloadManager != null) return sPreloadManager;
        Class<PreloadManager> clazz = PreloadManager.class;
        synchronized (PreloadManager.class) {
            if (sPreloadManager != null) return sPreloadManager;
            sPreloadManager = new PreloadManager(context.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sPreloadManager;
        }
    }

    public void addPreloadTask(String rawUrl, int position) {
        if (this.isPreloaded(rawUrl)) {
            return;
        }
        PreloadTask task = new PreloadTask();
        task.mRawUrl = rawUrl;
        task.mPosition = position;
        task.mCacheServer = this.mHttpProxyCacheServer;
        Logger.info("addPreloadTask: " + position);
        this.mPreloadTasks.put(rawUrl, task);
        if (this.mIsStartPreload) {
            task.executeOn(this.mExecutorService);
        }
    }

    private boolean isPreloaded(String rawUrl) {
        File cacheFile = this.mHttpProxyCacheServer.getCacheFile(rawUrl);
        if (cacheFile.exists()) {
            if (cacheFile.length() >= 1024L) {
                return true;
            }
            cacheFile.delete();
            return false;
        }
        File tempCacheFile = this.mHttpProxyCacheServer.getTempCacheFile(rawUrl);
        if (tempCacheFile.exists()) {
            return tempCacheFile.length() >= 524288L;
        }
        return false;
    }

    public void pausePreload(int position, boolean isReverseScroll) {
        Logger.info("pausePreload\uff1a" + position + " isReverseScroll: " + isReverseScroll);
        this.mIsStartPreload = false;
        for (Map.Entry<String, PreloadTask> next : this.mPreloadTasks.entrySet()) {
            PreloadTask task = next.getValue();
            if (isReverseScroll) {
                if (task.mPosition < position) continue;
                task.cancel();
                continue;
            }
            if (task.mPosition > position) continue;
            task.cancel();
        }
    }

    public void resumePreload(int position, boolean isReverseScroll) {
        Logger.info("resumePreload\uff1a" + position + " isReverseScroll: " + isReverseScroll);
        this.mIsStartPreload = true;
        for (Map.Entry<String, PreloadTask> next : this.mPreloadTasks.entrySet()) {
            PreloadTask task = next.getValue();
            if (isReverseScroll) {
                if (task.mPosition >= position || this.isPreloaded(task.mRawUrl)) continue;
                task.executeOn(this.mExecutorService);
                continue;
            }
            if (task.mPosition <= position || this.isPreloaded(task.mRawUrl)) continue;
            task.executeOn(this.mExecutorService);
        }
    }

    public void removePreloadTask(String rawUrl) {
        PreloadTask task = this.mPreloadTasks.get(rawUrl);
        if (task != null) {
            task.cancel();
            this.mPreloadTasks.remove(rawUrl);
        }
    }

    public void removeAllPreloadTask() {
        Iterator<Map.Entry<String, PreloadTask>> iterator = this.mPreloadTasks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, PreloadTask> next = iterator.next();
            PreloadTask task = next.getValue();
            task.cancel();
            iterator.remove();
        }
    }

    public String getPlayUrl(String rawUrl) {
        PreloadTask task = this.mPreloadTasks.get(rawUrl);
        if (task != null) {
            task.cancel();
        }
        if (this.isPreloaded(rawUrl)) {
            return this.mHttpProxyCacheServer.getProxyUrl(rawUrl);
        }
        return rawUrl;
    }
}

