/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videocache.file;

import com.yc.videocache.Logger;
import com.yc.videocache.file.DiskUsage;
import com.yc.videocache.file.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class LruDiskUsage
implements DiskUsage {
    private final ExecutorService workerThread = Executors.newSingleThreadExecutor();

    @Override
    public void touch(File file) throws IOException {
        this.workerThread.submit(new TouchCallable(file));
    }

    private void touchInBackground(File file) throws IOException {
        Files.setLastModifiedNow(file);
        List<File> files = Files.getLruListFiles(file.getParentFile());
        this.trim(files);
    }

    protected abstract boolean accept(File var1, long var2, int var4);

    private void trim(List<File> files) {
        long totalSize = this.countTotalSize(files);
        int totalCount = files.size();
        for (File file : files) {
            boolean accepted = this.accept(file, totalSize, totalCount);
            if (accepted) continue;
            long fileSize = file.length();
            boolean deleted = file.delete();
            if (deleted) {
                --totalCount;
                totalSize -= fileSize;
                Logger.info("Cache file " + file + " is deleted because it exceeds cache limit");
                continue;
            }
            Logger.error("Error deleting file " + file + " for trimming cache");
        }
    }

    private long countTotalSize(List<File> files) {
        long totalSize = 0L;
        for (File file : files) {
            totalSize += file.length();
        }
        return totalSize;
    }

    private class TouchCallable
    implements Callable<Void> {
        private final File file;

        public TouchCallable(File file) {
            this.file = file;
        }

        @Override
        public Void call() throws Exception {
            LruDiskUsage.this.touchInBackground(this.file);
            return null;
        }
    }
}

