/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videocache;

import android.text.TextUtils;
import com.yc.videocache.CacheListener;
import com.yc.videocache.GetRequest;
import com.yc.videocache.HttpUrlSource;
import com.yc.videocache.ProxyCache;
import com.yc.videocache.ProxyCacheException;
import com.yc.videocache.file.FileCache;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Locale;

class HttpProxyCache
extends ProxyCache {
    private static final float NO_CACHE_BARRIER = 0.2f;
    private final HttpUrlSource source;
    private final FileCache cache;
    private CacheListener listener;

    public HttpProxyCache(HttpUrlSource source, FileCache cache) {
        super(source, cache);
        this.cache = cache;
        this.source = source;
    }

    public void registerCacheListener(CacheListener cacheListener) {
        this.listener = cacheListener;
    }

    public void processRequest(GetRequest request, Socket socket) throws IOException, ProxyCacheException {
        BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
        String responseHeaders = this.newResponseHeaders(request);
        ((OutputStream)out).write(responseHeaders.getBytes("UTF-8"));
        long offset = request.rangeOffset;
        if (this.isUseCache(request)) {
            this.responseWithCache(out, offset);
        } else {
            this.responseWithoutCache(out, offset);
        }
    }

    private boolean isUseCache(GetRequest request) throws ProxyCacheException {
        long sourceLength = this.source.length();
        boolean sourceLengthKnown = sourceLength > 0L;
        long cacheAvailable = this.cache.available();
        return !sourceLengthKnown || !request.partial || (float)request.rangeOffset <= (float)cacheAvailable + (float)sourceLength * 0.2f;
    }

    private String newResponseHeaders(GetRequest request) throws IOException, ProxyCacheException {
        String mime = this.source.getMime();
        boolean mimeKnown = !TextUtils.isEmpty((CharSequence)mime);
        long length = this.cache.isCompleted() ? this.cache.available() : this.source.length();
        boolean lengthKnown = length >= 0L;
        long contentLength = request.partial ? length - request.rangeOffset : length;
        boolean addRange = lengthKnown && request.partial;
        return (request.partial ? "HTTP/1.1 206 PARTIAL CONTENT\n" : "HTTP/1.1 200 OK\n") + "Accept-Ranges: bytes\n" + (lengthKnown ? this.format("Content-Length: %d\n", contentLength) : "") + (addRange ? this.format("Content-Range: bytes %d-%d/%d\n", request.rangeOffset, length - 1L, length) : "") + (mimeKnown ? this.format("Content-Type: %s\n", mime) : "") + "\n";
    }

    private void responseWithCache(OutputStream out, long offset) throws ProxyCacheException, IOException {
        int readBytes;
        byte[] buffer = new byte[8192];
        while ((readBytes = this.read(buffer, offset, buffer.length)) != -1) {
            out.write(buffer, 0, readBytes);
            offset += (long)readBytes;
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void responseWithoutCache(OutputStream out, long offset) throws ProxyCacheException, IOException {
        try (HttpUrlSource newSourceNoCache = new HttpUrlSource(this.source);){
            int readBytes;
            newSourceNoCache.open((int)offset);
            byte[] buffer = new byte[8192];
            while ((readBytes = newSourceNoCache.read(buffer)) != -1) {
                out.write(buffer, 0, readBytes);
                offset += (long)readBytes;
            }
            out.flush();
        }
    }

    private String format(String pattern, Object ... args) {
        return String.format(Locale.US, pattern, args);
    }

    @Override
    protected void onCachePercentsAvailableChanged(int percents) {
        if (this.listener != null) {
            this.listener.onCacheAvailable(this.cache.file, this.source.getUrl(), percents);
        }
    }
}

