/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videocache;

import com.yc.videocache.HttpUrlSource;
import com.yc.videocache.Logger;
import com.yc.videocache.Preconditions;
import com.yc.videocache.ProxyCacheException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class Pinger {
    private static final String PING_REQUEST = "ping";
    private static final String PING_RESPONSE = "ping ok";
    private final ExecutorService pingExecutor = Executors.newSingleThreadExecutor();
    private final String host;
    private final int port;

    Pinger(String host, int port) {
        this.host = Preconditions.checkNotNull(host);
        this.port = port;
    }

    boolean ping(int maxAttempts, int startTimeout) {
        Preconditions.checkArgument(maxAttempts >= 1);
        Preconditions.checkArgument(startTimeout > 0);
        int timeout = startTimeout;
        int attempts = 0;
        while (attempts < maxAttempts) {
            try {
                Future<Boolean> pingFuture = this.pingExecutor.submit(new PingCallable());
                boolean pinged = pingFuture.get(timeout, TimeUnit.MILLISECONDS);
                if (pinged) {
                    return true;
                }
            }
            catch (TimeoutException e) {
                Logger.warn("Error pinging server (attempt: " + attempts + ", timeout: " + timeout + "). ");
            }
            catch (InterruptedException | ExecutionException e) {
                Logger.error("Error pinging server due to unexpected error");
            }
            ++attempts;
            timeout *= 2;
        }
        String error = String.format(Locale.US, "Error pinging server (attempts: %d, max timeout: %d). If you see this message, please, report at https://github.com/danikula/AndroidVideoCache/issues/134. Default proxies are: %s", attempts, timeout / 2, this.getDefaultProxies());
        Logger.error(error);
        return false;
    }

    private List<Proxy> getDefaultProxies() {
        try {
            ProxySelector defaultProxySelector = ProxySelector.getDefault();
            return defaultProxySelector.select(new URI(this.getPingUrl()));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    boolean isPingRequest(String request) {
        return PING_REQUEST.equals(request);
    }

    void responseToPing(Socket socket) throws IOException {
        OutputStream out = socket.getOutputStream();
        out.write("HTTP/1.1 200 OK\n\n".getBytes());
        out.write(PING_RESPONSE.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pingServer() throws ProxyCacheException {
        String pingUrl = this.getPingUrl();
        try (HttpUrlSource source = new HttpUrlSource(pingUrl);){
            byte[] expectedResponse = PING_RESPONSE.getBytes();
            source.open(0L);
            byte[] response = new byte[expectedResponse.length];
            source.read(response);
            boolean pingOk = Arrays.equals(expectedResponse, response);
            Logger.info("Ping response: `" + new String(response) + "`, pinged? " + pingOk);
            boolean bl = pingOk;
            return bl;
        }
    }

    private String getPingUrl() {
        return String.format(Locale.US, "http://%s:%d/%s", this.host, this.port, PING_REQUEST);
    }

    private class PingCallable
    implements Callable<Boolean> {
        private PingCallable() {
        }

        @Override
        public Boolean call() throws Exception {
            return Pinger.this.pingServer();
        }
    }
}

