/*
 * Decompiled with CFR 0.152.
 */
package com.yccx.livebuslib.utils;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleRegistry;
import android.os.Looper;
import java.lang.reflect.Field;

public class BusLibUtils {
    public boolean isMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    public static int getLifecycleObserverMapSize(Lifecycle lifecycle) {
        if (lifecycle == null) {
            return 0;
        }
        if (!(lifecycle instanceof LifecycleRegistry)) {
            return 0;
        }
        try {
            Field observerMapField = LifecycleRegistry.class.getDeclaredField("mObserverMap");
            observerMapField.setAccessible(true);
            Object mObserverMap = observerMapField.get(lifecycle);
            Class<?> superclass = mObserverMap.getClass().getSuperclass();
            Field mSizeField = null;
            if (superclass != null) {
                mSizeField = superclass.getDeclaredField("mSize");
                mSizeField.setAccessible(true);
                return (Integer)mSizeField.get(mObserverMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static void setLifecycleState(Lifecycle lifecycle, Lifecycle.State state) {
        if (lifecycle == null) {
            return;
        }
        if (!(lifecycle instanceof LifecycleRegistry)) {
            return;
        }
        try {
            Field mState = LifecycleRegistry.class.getDeclaredField("mState");
            mState.setAccessible(true);
            mState.set(lifecycle, state);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setLifecycleObserverMapSize(Lifecycle lifecycle, int size) {
        if (lifecycle == null) {
            return;
        }
        if (!(lifecycle instanceof LifecycleRegistry)) {
            return;
        }
        try {
            Field observerMapField = LifecycleRegistry.class.getDeclaredField("mObserverMap");
            observerMapField.setAccessible(true);
            Object mObserverMap = observerMapField.get(lifecycle);
            Class<?> superclass = mObserverMap.getClass().getSuperclass();
            Field mSizeField = null;
            if (superclass != null) {
                mSizeField = superclass.getDeclaredField("mSize");
                mSizeField.setAccessible(true);
                mSizeField.set(mObserverMap, size);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

