/*
 * Decompiled with CFR 0.152.
 */
package com.yccx.livebuslib.data;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.Observer;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.yccx.livebuslib.event.LiveDataBus;
import com.yccx.livebuslib.helper.BusWeakHandler;
import com.yccx.livebuslib.inter.BusObservable;
import com.yccx.livebuslib.utils.BusLibUtils;
import com.yccx.livebuslib.utils.BusLogUtils;
import com.yccx.livebuslib.wrapper.SafeCastObserver;
import com.yccx.livebuslib.wrapper.WrapperObserver;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class BusMutableLiveData<T>
extends MutableLiveData<T>
implements BusObservable<T> {
    private Map<Observer, Observer> observerMap = new HashMap<Observer, Observer>();
    private BusWeakHandler mainHandler = new BusWeakHandler(Looper.getMainLooper());
    private Map<String, IntervalValueTask> intervalTasks = new HashMap<String, IntervalValueTask>();
    private String mKey;

    public BusMutableLiveData(String key) {
        this.mKey = key;
    }

    @Override
    public void setValue(T value) {
        super.setValue(value);
    }

    @Override
    public void postValue(T value) {
        this.mainHandler.post(new PostValueTask(value));
    }

    @Override
    public void postValueDelay(T value, long delay) {
        this.mainHandler.postDelayed(new PostValueTask(value), delay);
    }

    @Override
    @Deprecated
    public void postValueInterval(T value, long interval, @NonNull String taskName) {
        if (taskName.isEmpty()) {
            return;
        }
        IntervalValueTask intervalTask = new IntervalValueTask(value, interval);
        this.intervalTasks.put(taskName, intervalTask);
        this.mainHandler.postDelayed(intervalTask, interval);
    }

    @Override
    @Deprecated
    public void stopPostInterval(@NonNull String taskName) {
        IntervalValueTask intervalTask = this.intervalTasks.get(taskName);
        if (intervalTask != null) {
            this.mainHandler.removeCallbacks(intervalTask);
            this.intervalTasks.remove(taskName);
        }
    }

    @Override
    public void observe(@NonNull LifecycleOwner owner, @NonNull Observer<T> observer) {
        this.setHook(owner, observer);
    }

    @Override
    public void observeForever(@NonNull Observer<T> observer) {
        if (!this.observerMap.containsKey(observer)) {
            this.observerMap.put(observer, new WrapperObserver<T>(observer));
        }
        super.observeForever(this.observerMap.get(observer));
    }

    @Override
    public void removeObserver(@NonNull Observer<T> observer) {
        Observer realObserver = null;
        realObserver = this.observerMap.containsKey(observer) ? this.observerMap.remove(observer) : observer;
        super.removeObserver(realObserver);
        if (!this.hasObservers() && LiveDataBus.get().getBus() != null) {
            LiveDataBus.get().getBus().remove(this.mKey);
        }
    }

    @Override
    public void observeSticky(@NonNull LifecycleOwner owner, @NonNull Observer<T> observer) {
        super.observe(owner, new SafeCastObserver<T>(observer));
    }

    @Override
    public void observeStickyForever(@NonNull Observer<T> observer) {
        super.observeForever(observer);
    }

    protected void onInactive() {
        super.onInactive();
    }

    private void setHook(LifecycleOwner owner, Observer<T> observer) {
        SafeCastObserver<T> safeCastObserver = new SafeCastObserver<T>(observer);
        Lifecycle lifecycle = owner.getLifecycle();
        Lifecycle.State currentState = lifecycle.getCurrentState();
        int observerSize = BusLibUtils.getLifecycleObserverMapSize(lifecycle);
        boolean needChangeState = currentState.isAtLeast(Lifecycle.State.STARTED);
        BusLogUtils.d("--observe----------" + currentState.name() + "-----" + observerSize + "------" + needChangeState);
        if (needChangeState) {
            BusLibUtils.setLifecycleState(lifecycle, Lifecycle.State.INITIALIZED);
            BusLibUtils.setLifecycleObserverMapSize(lifecycle, -1);
        }
        super.observe(owner, safeCastObserver);
        if (needChangeState) {
            BusLibUtils.setLifecycleState(lifecycle, currentState);
            BusLibUtils.setLifecycleObserverMapSize(lifecycle, observerSize + 1);
            this.hookObserverActive(safeCastObserver, true);
        }
        this.hookObserverVersion(safeCastObserver);
    }

    private void hook(@NonNull Observer<T> observer) {
        try {
            Class<LiveData> classLiveData = LiveData.class;
            Field fieldObservers = classLiveData.getDeclaredField("mObservers");
            fieldObservers.setAccessible(true);
            Object objectObservers = fieldObservers.get(this);
            Class<?> classObservers = objectObservers.getClass();
            Method methodGet = classObservers.getDeclaredMethod("get", Object.class);
            methodGet.setAccessible(true);
            Object objectWrapperEntry = methodGet.invoke(objectObservers, observer);
            Object objectWrapper = null;
            if (objectWrapperEntry instanceof Map.Entry) {
                objectWrapper = ((Map.Entry)objectWrapperEntry).getValue();
            }
            if (objectWrapper == null) {
                throw new NullPointerException("Wrapper can not be bull!");
            }
            Class<?> classObserverWrapper = objectWrapper.getClass().getSuperclass();
            Field fieldLastVersion = null;
            if (classObserverWrapper != null) {
                fieldLastVersion = classObserverWrapper.getDeclaredField("mLastVersion");
                fieldLastVersion.setAccessible(true);
                Field fieldVersion = classLiveData.getDeclaredField("mVersion");
                fieldVersion.setAccessible(true);
                Object objectVersion = fieldVersion.get(this);
                fieldLastVersion.set(objectWrapper, objectVersion);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hookObserverActive(@NonNull Observer<T> observer, boolean active) {
        try {
            Object objectWrapper = this.getObserverWrapper(observer);
            if (objectWrapper == null) {
                return;
            }
            Class<?> classObserverWrapper = objectWrapper.getClass().getSuperclass();
            Field mActive = null;
            if (classObserverWrapper != null) {
                mActive = classObserverWrapper.getDeclaredField("mActive");
                mActive.setAccessible(true);
                mActive.set(objectWrapper, active);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Object getObserverWrapper(@NonNull Observer<T> observer) throws Exception {
        Field fieldObservers = LiveData.class.getDeclaredField("mObservers");
        fieldObservers.setAccessible(true);
        Object objectObservers = fieldObservers.get(this);
        Class<?> classObservers = objectObservers.getClass();
        Method methodGet = classObservers.getDeclaredMethod("get", Object.class);
        methodGet.setAccessible(true);
        Object objectWrapperEntry = methodGet.invoke(objectObservers, observer);
        Object objectWrapper = null;
        if (objectWrapperEntry instanceof Map.Entry) {
            objectWrapper = ((Map.Entry)objectWrapperEntry).getValue();
        }
        return objectWrapper;
    }

    private void hookObserverVersion(@NonNull Observer<T> observer) {
        try {
            Object objectWrapper = this.getObserverWrapper(observer);
            if (objectWrapper == null) {
                return;
            }
            Class<?> classObserverWrapper = objectWrapper.getClass().getSuperclass();
            Field fieldLastVersion = null;
            if (classObserverWrapper != null) {
                fieldLastVersion = classObserverWrapper.getDeclaredField("mLastVersion");
                fieldLastVersion.setAccessible(true);
                Field fieldVersion = LiveData.class.getDeclaredField("mVersion");
                fieldVersion.setAccessible(true);
                Object objectVersion = fieldVersion.get(this);
                fieldLastVersion.set(objectWrapper, objectVersion);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class IntervalValueTask
    implements Runnable {
        private T newValue;
        private long interval;

        public IntervalValueTask(T newValue, long interval) {
            this.newValue = newValue;
            this.interval = interval;
        }

        @Override
        public void run() {
            BusMutableLiveData.this.setValue(this.newValue);
            BusMutableLiveData.this.mainHandler.postDelayed(this, this.interval);
        }
    }

    private class PostValueTask
    implements Runnable {
        private T newValue;

        public PostValueTask(T newValue) {
            this.newValue = newValue;
        }

        @Override
        public void run() {
            BusMutableLiveData.this.setValue(this.newValue);
        }
    }
}

