/*
 * Decompiled with CFR 0.152.
 */
package com.yccx.livebuslib.data;

import android.arch.lifecycle.ExternalLiveData;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.yccx.livebuslib.event.LiveDataBus;
import com.yccx.livebuslib.helper.BusWeakHandler;
import com.yccx.livebuslib.inter.BusObservable;
import com.yccx.livebuslib.wrapper.SafeCastObserver;
import com.yccx.livebuslib.wrapper.WrapperObserver;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class BusLiveData<T>
extends ExternalLiveData<T>
implements BusObservable<T> {
    private Map<Observer, Observer> observerMap = new HashMap<Observer, Observer>();
    private BusWeakHandler mainHandler = new BusWeakHandler(Looper.getMainLooper());
    private Map<String, IntervalValueTask> intervalTasks = new HashMap<String, IntervalValueTask>();
    private String mKey;

    public BusLiveData(String key) {
        this.mKey = key;
    }

    @Override
    public void setValue(T value) {
        super.setValue(value);
    }

    @Override
    public void postValue(T value) {
        this.mainHandler.post(new PostValueTask(value));
    }

    @Override
    public void postValueDelay(T value, long delay) {
        this.mainHandler.postDelayed(new PostValueTask(value), delay);
    }

    @Override
    @Deprecated
    public void postValueInterval(T value, long interval, @NonNull String taskName) {
        if (taskName.isEmpty()) {
            return;
        }
        IntervalValueTask intervalTask = new IntervalValueTask(value, interval);
        this.intervalTasks.put(taskName, intervalTask);
        this.mainHandler.postDelayed(intervalTask, interval);
    }

    @Override
    @Deprecated
    public void stopPostInterval(@NonNull String taskName) {
        IntervalValueTask intervalTask = this.intervalTasks.get(taskName);
        if (intervalTask != null) {
            this.mainHandler.removeCallbacks(intervalTask);
            this.intervalTasks.remove(taskName);
        }
    }

    @Override
    public void observe(@NonNull LifecycleOwner owner, @NonNull Observer<T> observer) {
        super.observe(owner, new SafeCastObserver<T>(observer));
    }

    @Override
    public void observeForever(@NonNull Observer<T> observer) {
        if (!this.observerMap.containsKey(observer)) {
            this.observerMap.put(observer, new WrapperObserver<T>(observer));
        }
        super.observeForever(this.observerMap.get(observer));
    }

    @Override
    public void removeObserver(@NonNull Observer<T> observer) {
        Observer realObserver = null;
        realObserver = this.observerMap.containsKey(observer) ? this.observerMap.remove(observer) : observer;
        super.removeObserver(realObserver);
        if (!this.hasObservers() && LiveDataBus.get().getBus() != null) {
            LiveDataBus.get().getBus().remove(this.mKey);
        }
    }

    @Override
    public void observeSticky(@NonNull LifecycleOwner owner, @NonNull Observer<T> observer) {
        super.observeSticky(owner, new SafeCastObserver<T>(observer));
    }

    @Override
    public void observeStickyForever(@NonNull Observer<T> observer) {
        super.observeForever(observer);
    }

    @Override
    protected Lifecycle.State observerActiveLevel() {
        return LiveDataBus.get().isLifecycleObserverAlwaysActive() ? Lifecycle.State.CREATED : Lifecycle.State.STARTED;
    }

    private class IntervalValueTask
    implements Runnable {
        private T newValue;
        private long interval;

        public IntervalValueTask(T newValue, long interval) {
            this.newValue = newValue;
            this.interval = interval;
        }

        @Override
        public void run() {
            BusLiveData.this.setValue(this.newValue);
            BusLiveData.this.mainHandler.postDelayed(this, this.interval);
        }
    }

    private class PostValueTask
    implements Runnable {
        private T newValue;

        public PostValueTask(T newValue) {
            this.newValue = newValue;
        }

        @Override
        public void run() {
            BusLiveData.this.setValue(this.newValue);
        }
    }
}

