/*
 * Decompiled with CFR 0.152.
 */
package com.yccx.livebuslib.wrapper;

import android.arch.lifecycle.Observer;
import android.support.annotation.Nullable;

public class WrapperObserver<T>
implements Observer<T> {
    private Observer<T> observer;

    public WrapperObserver(Observer<T> observer) {
        this.observer = observer;
    }

    public void onChanged(@Nullable T t) {
        if (this.observer != null) {
            if (this.isCallOnObserve()) {
                return;
            }
            this.observer.onChanged(t);
        }
    }

    private boolean isCallOnObserve() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace != null && stackTrace.length > 0) {
            for (StackTraceElement element : stackTrace) {
                if (!"android.arch.lifecycle.LiveData".equals(element.getClassName()) || !"observeForever".equals(element.getMethodName())) continue;
                return true;
            }
        }
        return false;
    }
}

