/*
 * Decompiled with CFR 0.152.
 */
package io.rong.models.message;

import io.rong.models.message.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PushExt {
    private String title;
    private String templateId;
    private int forceShowPushContent;
    private List<Platform> pushConfigs;

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setForceShowPushContent(int forceShowPushContent) {
        this.forceShowPushContent = forceShowPushContent;
    }

    public int getForceShowPushContent() {
        return this.forceShowPushContent;
    }

    public void setPushConfigs(List<Platform> pushConfigs) {
        this.pushConfigs = pushConfigs;
    }

    public List<Platform> getPushConfigs() {
        return this.pushConfigs;
    }

    public static PushExt build(String title, Integer forceShowPushContent, Platform ... platforms) {
        PushExt pe = new PushExt();
        pe.setTitle(title);
        if (forceShowPushContent != null) {
            pe.setForceShowPushContent(forceShowPushContent);
        }
        ArrayList<Platform> pushConfigs = new ArrayList<Platform>();
        for (Platform p : platforms) {
            pushConfigs.add(p);
        }
        pe.setPushConfigs(pushConfigs);
        return pe;
    }

    public static class OPPO
    implements Platform {
        private HashMap<String, String> OPPO = new HashMap();

        public OPPO(String channelId) {
            this.OPPO.put("channelId", channelId);
        }

        public HashMap<String, String> getOPPO() {
            return this.OPPO;
        }

        public void setOPPO(HashMap<String, String> OPPO2) {
        }
    }

    public static class VIVO
    implements Platform {
        private HashMap<String, String> VIVO = new HashMap();

        public VIVO(String classification) {
            this.VIVO.put("classification", classification);
        }

        public HashMap<String, String> getVIVO() {
            return this.VIVO;
        }

        public void setVIVO(HashMap<String, String> VIVO2) {
        }
    }

    public static class APNs
    implements Platform {
        private HashMap<String, String> APNs = new HashMap();

        public APNs(String thread_id, String apns_collapse_id) {
            this.APNs.put("thread-id", thread_id);
            this.APNs.put("apns-collapse-id", apns_collapse_id);
        }

        public HashMap<String, String> getAPNs() {
            return this.APNs;
        }

        public void setAPNs(HashMap<String, String> aPNs) {
            this.APNs = aPNs;
        }
    }

    public static class HW
    implements Platform {
        private HashMap<String, String> HW = new HashMap();

        public HW(String channelId) {
            this.HW.put("channelId", channelId);
        }

        public HW(String channelId, String importance) {
            this.HW.put("channelId", channelId);
            this.HW.put("importance", importance);
        }

        public HashMap<String, String> getHW() {
            return this.HW;
        }

        public void setHW(HashMap<String, String> hW) {
            this.HW = hW;
        }
    }
}

