/*
 * Decompiled with CFR 0.152.
 */
package cn.craccd.mongoHelper.utils;

import cn.craccd.mongoHelper.bean.Page;
import cn.craccd.mongoHelper.utils.MongoHelper;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.json.JSONUtil;
import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class ImportExportUtil {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoHelper mongoHelper;
    @Value(value="${spring.data.mongodb.package}")
    private String packageName;

    public void exportDb(String path) {
        path = path.replace(".zip", "");
        FileUtil.del((String)path);
        FileUtil.del((String)(path + ".zip"));
        try {
            Set set = ClassUtil.scanPackage((String)this.packageName);
            Page page = new Page();
            page.setLimit(1000);
            for (Class clazz : set) {
                page.setCurr(1);
                while ((page = this.mongoHelper.findPage(page, clazz)).getRecords().size() != 0) {
                    ArrayList<String> lines = new ArrayList<String>();
                    for (Object object : page.getRecords()) {
                        lines.add(JSONUtil.toJsonStr(object));
                    }
                    FileUtil.appendLines(lines, (String)(path + File.separator + clazz.getSimpleName() + ".json"), (String)"UTF-8");
                    System.out.println(clazz.getSimpleName() + "\u8868\u5bfc\u51fa\u4e86" + page.getRecords().size() + "\u6761\u6570\u636e");
                    page.setCurr(page.getCurr() + 1);
                }
            }
            ZipUtil.zip((String)path);
        }
        catch (Exception e) {
            e.printStackTrace();
            FileUtil.del((String)(path + ".zip"));
        }
        FileUtil.del((String)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importDb(String path) {
        if (!FileUtil.exist((String)path)) {
            System.out.println(path + "\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        BufferedReader reader = null;
        path = path.replace(".zip", "");
        FileUtil.del((String)path);
        ZipUtil.unzip((String)(path + ".zip"));
        try {
            Set set = ClassUtil.scanPackage((String)this.packageName);
            block5: for (Class clazz : set) {
                File file = new File(path + File.separator + clazz.getSimpleName() + ".json");
                if (!file.exists()) continue;
                this.mongoTemplate.dropCollection(clazz);
                reader = FileUtil.getReader((File)file, (String)"UTF-8");
                ArrayList<Object> list = new ArrayList<Object>();
                while (true) {
                    String json;
                    if (StrUtil.isEmpty((CharSequence)(json = reader.readLine()))) {
                        this.mongoTemplate.insertAll(list);
                        System.out.println(clazz.getSimpleName() + "\u8868\u5bfc\u5165\u4e86" + list.size() + "\u6761\u6570\u636e");
                        list.clear();
                        continue block5;
                    }
                    list.add(JSONUtil.toBean((String)json, (Class)clazz));
                    if (list.size() != 1000) continue;
                    this.mongoTemplate.insertAll(list);
                    System.out.println(clazz.getSimpleName() + "\u8868\u5bfc\u5165\u4e86" + list.size() + "\u6761\u6570\u636e");
                    list.clear();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IoUtil.close(reader);
        }
        FileUtil.del((String)path);
    }
}

