/*
 * Decompiled with CFR 0.152.
 */
package cn.craccd.mongoHelper.config;

import cn.craccd.mongoHelper.bean.InitValue;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.mongodb.client.result.UpdateResult;
import java.lang.reflect.Field;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class ScanNewField {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Value(value="${spring.data.mongodb.package}")
    private String packageName;
    @Autowired
    MongoMappingContext mongoMappingContext;

    @EventListener(value={ApplicationReadyEvent.class})
    public void scan() {
        this.mongoMappingContext.setAutoIndexCreation(true);
        if (StrUtil.isEmpty((CharSequence)this.packageName)) {
            return;
        }
        Set set = ClassUtil.scanPackage((String)this.packageName);
        for (Class clazz : set) {
            Field[] fields;
            if (!this.mongoTemplate.collectionExists(clazz)) {
                this.mongoTemplate.createCollection(clazz);
                System.out.println("\u521b\u5efa\u4e86" + clazz.getSimpleName() + "\u8868");
            }
            for (Field field : fields = ReflectUtil.getFields((Class)clazz)) {
                InitValue defaultValue;
                if (!field.isAnnotationPresent(InitValue.class) || (defaultValue = field.getAnnotation(InitValue.class)).value() == null) continue;
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)field.getName()).is(null));
                Long count = this.mongoTemplate.count(query, clazz);
                if (count <= 0L) continue;
                Update update = new Update().set(field.getName(), (Object)defaultValue.value());
                UpdateResult updateResult = this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, clazz);
                System.out.println(clazz.getSimpleName() + "\u8868\u66f4\u65b0\u4e86" + updateResult.getModifiedCount() + "\u6761\u9ed8\u8ba4\u503c");
            }
        }
    }
}

