//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.sas.v1_0_0.model.VersionRouteInfo;
import cn.com.antcloud.api.provider.sas.v1_0_0.response.UpdateServerlessappserviceRouteweightResponse;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 每个版本的流量权重是版本权重除以总权重.
 * (注意, 每次更新需要传全量替换. 比如原先的版本是A版本权重30 B版本权重70. 调用这个接口传的参数是A版本权重60, C版本权重40. 那么最终A版本的流量比是60%, B版本是0, C版本是40%)
 */
public class UpdateServerlessappserviceRouteweightRequest extends AntCloudProviderRequest<UpdateServerlessappserviceRouteweightResponse> {
  @NotNull
  private String appServiceName;

  private Boolean shared;

  private List<VersionRouteInfo> versionRouteInfos;

  @NotNull
  private String workspace;

  public UpdateServerlessappserviceRouteweightRequest() {
    super("antcloud.sas.serverlessappservice.routeweight.update", "1.0", "Java-SDK-20190410");
  }

  /**
   * 应用实例名称 */
  public String getAppServiceName() {
    return this.appServiceName;
  }

  /**
   * 应用实例名称 */
  public void setAppServiceName(String appServiceName) {
    this.appServiceName = appServiceName;
  }

  /**
   * 是否是共享集群
   * 如果是共享集群, 则需要填写cluster
   * 默认为true */
  public Boolean getShared() {
    return this.shared;
  }

  /**
   * 是否是共享集群
   * 如果是共享集群, 则需要填写cluster
   * 默认为true */
  public void setShared(Boolean shared) {
    this.shared = shared;
  }

  /**
   * full_version和weight必填 */
  public List<VersionRouteInfo> getVersionRouteInfos() {
    return this.versionRouteInfos;
  }

  /**
   * full_version和weight必填 */
  public void setVersionRouteInfos(List<VersionRouteInfo> versionRouteInfos) {
    this.versionRouteInfos = versionRouteInfos;
  }

  /**
   * 环境标识 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 环境标识 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
