//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.sas.v1_0_0.response.UpdateCodepackageUploadstatusResponse;
import java.lang.Boolean;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 更新代码包上传状态
 */
public class UpdateCodepackageUploadstatusRequest extends AntCloudProviderRequest<UpdateCodepackageUploadstatusResponse> {
  @NotNull
  private String appServiceFullVersion;

  @NotNull
  private String appServiceName;

  private Boolean shared;

  @NotNull
  private String workspace;

  public UpdateCodepackageUploadstatusRequest() {
    super("antcloud.sas.codepackage.uploadstatus.update", "1.0", "Java-SDK-20190410");
  }

  /**
   * 代码包所属的版本 */
  public String getAppServiceFullVersion() {
    return this.appServiceFullVersion;
  }

  /**
   * 代码包所属的版本 */
  public void setAppServiceFullVersion(String appServiceFullVersion) {
    this.appServiceFullVersion = appServiceFullVersion;
  }

  /**
   * 代码包对应的应用实例名称 */
  public String getAppServiceName() {
    return this.appServiceName;
  }

  /**
   * 代码包对应的应用实例名称 */
  public void setAppServiceName(String appServiceName) {
    this.appServiceName = appServiceName;
  }

  /**
   * 是否是共享集群 如果是共享集群, 则需要填写cluster 默认为true */
  public Boolean getShared() {
    return this.shared;
  }

  /**
   * 是否是共享集群 如果是共享集群, 则需要填写cluster 默认为true */
  public void setShared(Boolean shared) {
    this.shared = shared;
  }

  /**
   * 环境标识 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 环境标识 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
