//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.sas.v1_0_0.response.QueryServerlessappserviceResponse;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 分页查询应用实例的基本信息
 */
public class QueryServerlessappserviceRequest extends AntCloudProviderRequest<QueryServerlessappserviceResponse> {
  private Date creationTimeFrom;

  private Date creationTimeTo;

  private List<String> creatorIds;

  private List<String> names;

  private String nameLike;

  private Long pageNum;

  private Long pageSize;

  private Boolean shared;

  private List<String> techstackIdentities;

  @NotNull
  private String workspace;

  public QueryServerlessappserviceRequest() {
    super("antcloud.sas.serverlessappservice.query", "1.0", "Java-SDK-20190410");
  }

  /**
   * 应用实例创建时间起始 */
  public Date getCreationTimeFrom() {
    return this.creationTimeFrom;
  }

  /**
   * 应用实例创建时间起始 */
  public void setCreationTimeFrom(Date creationTimeFrom) {
    this.creationTimeFrom = creationTimeFrom;
  }

  /**
   * 应用实例创建时间终止 */
  public Date getCreationTimeTo() {
    return this.creationTimeTo;
  }

  /**
   * 应用实例创建时间终止 */
  public void setCreationTimeTo(Date creationTimeTo) {
    this.creationTimeTo = creationTimeTo;
  }

  /**
   * n范围1-5
   * 匹配服务实例的创建人id */
  public List<String> getCreatorIds() {
    return this.creatorIds;
  }

  /**
   * n范围1-5
   * 匹配服务实例的创建人id */
  public void setCreatorIds(List<String> creatorIds) {
    this.creatorIds = creatorIds;
  }

  /**
   * 应用实例名称， 精确匹配，和name_like是互斥的。
   * n范围: 0 - 50 */
  public List<String> getNames() {
    return this.names;
  }

  /**
   * 应用实例名称， 精确匹配，和name_like是互斥的。
   * n范围: 0 - 50 */
  public void setNames(List<String> names) {
    this.names = names;
  }

  /**
   * 应用实例的名称. 模糊匹配 */
  public String getNameLike() {
    return this.nameLike;
  }

  /**
   * 应用实例的名称. 模糊匹配 */
  public void setNameLike(String nameLike) {
    this.nameLike = nameLike;
  }

  /**
   * 范围：大于等于1
   * 查询页号，起始为1，默认值1 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 范围：大于等于1
   * 查询页号，起始为1，默认值1 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 范围：1 - 50
   * 查询每页大小 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 范围：1 - 50
   * 查询每页大小 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 是否是共享集群
   * 如果是共享集群, 则需要填写cluster
   * 默认为true */
  public Boolean getShared() {
    return this.shared;
  }

  /**
   * 是否是共享集群
   * 如果是共享集群, 则需要填写cluster
   * 默认为true */
  public void setShared(Boolean shared) {
    this.shared = shared;
  }

  /**
   * 匹配技术栈标识
   * n范围1-5 */
  public List<String> getTechstackIdentities() {
    return this.techstackIdentities;
  }

  /**
   * 匹配技术栈标识
   * n范围1-5 */
  public void setTechstackIdentities(List<String> techstackIdentities) {
    this.techstackIdentities = techstackIdentities;
  }

  /**
   * 环境标识 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 环境标识 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
