//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.sas.v1_0_0.response.QueryRuntimeResponse;
import java.lang.String;

/**
 * 查询符合条件的运行时
 */
public class QueryRuntimeRequest extends AntCloudProviderRequest<QueryRuntimeResponse> {
  private String runtimeIdentity;

  private String techstackIdentity;

  public QueryRuntimeRequest() {
    super("antcloud.sas.runtime.query", "1.0", "Java-SDK-20190410");
  }

  /**
   * 运行时标识 */
  public String getRuntimeIdentity() {
    return this.runtimeIdentity;
  }

  /**
   * 运行时标识 */
  public void setRuntimeIdentity(String runtimeIdentity) {
    this.runtimeIdentity = runtimeIdentity;
  }

  /**
   * 技术栈标识 */
  public String getTechstackIdentity() {
    return this.techstackIdentity;
  }

  /**
   * 技术栈标识 */
  public void setTechstackIdentity(String techstackIdentity) {
    this.techstackIdentity = techstackIdentity;
  }
}
