//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.sas.v1_0_0.response.QueryLogResponse;
import java.lang.Long;
import java.lang.String;
import java.util.Date;
import javax.validation.constraints.NotNull;

/**
 * 获取版本日志
 */
public class QueryLogRequest extends AntCloudProviderRequest<QueryLogResponse> {
  private String filePath;

  private Date fromDate;

  private Long pageNum;

  private Long pageSize;

  private String query;

  @NotNull
  private String serverlessAppServiceName;

  private String topic;

  private Date toDate;

  @NotNull
  private String workspace;

  public QueryLogRequest() {
    super("antcloud.sas.log.query", "1.0", "Java-SDK-20190410");
  }

  /**
   * 支持通配符 */
  public String getFilePath() {
    return this.filePath;
  }

  /**
   * 支持通配符 */
  public void setFilePath(String filePath) {
    this.filePath = filePath;
  }

  /**
   * 开始日期 */
  public Date getFromDate() {
    return this.fromDate;
  }

  /**
   * 开始日期 */
  public void setFromDate(Date fromDate) {
    this.fromDate = fromDate;
  }

  /**
   * 查询的页数 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 查询的页数 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 查询页大小 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 查询页大小 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 日志关键字 */
  public String getQuery() {
    return this.query;
  }

  /**
   * 日志关键字 */
  public void setQuery(String query) {
    this.query = query;
  }

  /**
   * 应用实例名称 */
  public String getServerlessAppServiceName() {
    return this.serverlessAppServiceName;
  }

  /**
   * 应用实例名称 */
  public void setServerlessAppServiceName(String serverlessAppServiceName) {
    this.serverlessAppServiceName = serverlessAppServiceName;
  }

  /**
   * 文件名关键字 */
  public String getTopic() {
    return this.topic;
  }

  /**
   * 文件名关键字 */
  public void setTopic(String topic) {
    this.topic = topic;
  }

  /**
   * 结束日期 */
  public Date getToDate() {
    return this.toDate;
  }

  /**
   * 结束日期 */
  public void setToDate(Date toDate) {
    this.toDate = toDate;
  }

  /**
   * 环境标识 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 环境标识 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
