//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.sas.v1_0_0.response.GetTenantworkspaceconfigResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 获取当前租户在某个workspace的配置信息
 */
public class GetTenantworkspaceconfigRequest extends AntCloudProviderRequest<GetTenantworkspaceconfigResponse> {
  @NotNull
  private String cluster;

  @NotNull
  private String workspace;

  public GetTenantworkspaceconfigRequest() {
    super("antcloud.sas.tenantworkspaceconfig.get", "1.0", "Java-SDK-20190410");
  }

  /**
   * 集群标识 */
  public String getCluster() {
    return this.cluster;
  }

  /**
   * 集群标识 */
  public void setCluster(String cluster) {
    this.cluster = cluster;
  }

  /**
   * 环境标识 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 环境标识 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
