//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.sas.v1_0_0.response.GetTenantregionconfigResponse;
import java.lang.String;

/**
 * 获得租户在某个地域的最大实例数配置
 */
public class GetTenantregionconfigRequest extends AntCloudProviderRequest<GetTenantregionconfigResponse> {
  private String region;

  private String workspace;

  public GetTenantregionconfigRequest() {
    super("antcloud.sas.tenantregionconfig.get", "1.0", "Java-SDK-20190410");
  }

  /**
   * 地域标识
   * tenant需要传
   * workspace和region二选一 */
  public String getRegion() {
    return this.region;
  }

  /**
   * 地域标识
   * tenant需要传
   * workspace和region二选一 */
  public void setRegion(String region) {
    this.region = region;
  }

  /**
   * 环境标识(workspace和region二选一) */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 环境标识(workspace和region二选一) */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
