//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.sas.v1_0_0.response.GetServerlessappserviceVersionResponse;
import java.lang.Boolean;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 获取版本详情
 */
public class GetServerlessappserviceVersionRequest extends AntCloudProviderRequest<GetServerlessappserviceVersionResponse> {
  @NotNull
  private String appServiceName;

  @NotNull
  private String fullVersion;

  private Boolean shared;

  @NotNull
  private String workspace;

  public GetServerlessappserviceVersionRequest() {
    super("antcloud.sas.serverlessappservice.version.get", "1.0", "Java-SDK-20190410");
  }

  /**
   * 应用实例的名称 */
  public String getAppServiceName() {
    return this.appServiceName;
  }

  /**
   * 应用实例的名称 */
  public void setAppServiceName(String appServiceName) {
    this.appServiceName = appServiceName;
  }

  /**
   * 版本号
   */
  public String getFullVersion() {
    return this.fullVersion;
  }

  /**
   * 版本号
   */
  public void setFullVersion(String fullVersion) {
    this.fullVersion = fullVersion;
  }

  /**
   * 是否是共享集群
   * 如果是共享集群, 则需要填写cluster
   * 默认为true */
  public Boolean getShared() {
    return this.shared;
  }

  /**
   * 是否是共享集群
   * 如果是共享集群, 则需要填写cluster
   * 默认为true */
  public void setShared(Boolean shared) {
    this.shared = shared;
  }

  /**
   * 环境标识 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 环境标识 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
