//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.sas.v1_0_0.response.DisableTimetriggerResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 禁用时间触发器
 */
public class DisableTimetriggerRequest extends AntCloudProviderRequest<DisableTimetriggerResponse> {
  @NotNull
  private String identity;

  @NotNull
  private String workspace;

  public DisableTimetriggerRequest() {
    super("antcloud.sas.timetrigger.disable", "1.0", "Java-SDK-20190410");
  }

  /**
   * 触发器标识 */
  public String getIdentity() {
    return this.identity;
  }

  /**
   * 触发器标识 */
  public void setIdentity(String identity) {
    this.identity = identity;
  }

  /**
   * 环境标识 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 环境标识 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
