//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.sas.v1_0_0.response.CreateTimetriggerResponse;
import java.lang.String;
import java.util.Date;
import javax.validation.constraints.NotNull;

/**
 * 创建时间触发器
 */
public class CreateTimetriggerRequest extends AntCloudProviderRequest<CreateTimetriggerResponse> {
  private String creatorId;

  private String cronExpression;

  private String description;

  private Date firstScheduleTime;

  @NotNull
  private String identity;

  @NotNull
  private String name;

  @NotNull
  private String periodCategory;

  @NotNull
  private String workspace;

  public CreateTimetriggerRequest() {
    super("antcloud.sas.timetrigger.create", "1.0", "Java-SDK-20190410");
  }

  /**
   * 创建人id */
  public String getCreatorId() {
    return this.creatorId;
  }

  /**
   * 创建人id */
  public void setCreatorId(String creatorId) {
    this.creatorId = creatorId;
  }

  /**
   * 当执行周期为CRON_EXPRESSION时, 需要填写该值
   */
  public String getCronExpression() {
    return this.cronExpression;
  }

  /**
   * 当执行周期为CRON_EXPRESSION时, 需要填写该值
   */
  public void setCronExpression(String cronExpression) {
    this.cronExpression = cronExpression;
  }

  /**
   * 描述 */
  public String getDescription() {
    return this.description;
  }

  /**
   * 描述 */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * 首次执行时间
   * 当period_category不为CRON_EXPRESSION需要填写该值 */
  public Date getFirstScheduleTime() {
    return this.firstScheduleTime;
  }

  /**
   * 首次执行时间
   * 当period_category不为CRON_EXPRESSION需要填写该值 */
  public void setFirstScheduleTime(Date firstScheduleTime) {
    this.firstScheduleTime = firstScheduleTime;
  }

  /**
   * 触发器标识, 环境维度下唯一 */
  public String getIdentity() {
    return this.identity;
  }

  /**
   * 触发器标识, 环境维度下唯一 */
  public void setIdentity(String identity) {
    this.identity = identity;
  }

  /**
   * 触发器名称, 环境维度下唯一 */
  public String getName() {
    return this.name;
  }

  /**
   * 触发器名称, 环境维度下唯一 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 执行周期
   *
   */
  public String getPeriodCategory() {
    return this.periodCategory;
  }

  /**
   * 执行周期
   *
   */
  public void setPeriodCategory(String periodCategory) {
    this.periodCategory = periodCategory;
  }

  /**
   * 环境标识 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 环境标识 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
