//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.model;

import java.lang.String;
import java.util.Date;

/**
 * 代码包上传地址信息 */
public class UploadEndpoint {
  private String accessKeyId;

  private String bucket;

  private String encodedPolicy;

  private Date expiration;

  private String filePath;

  private String host;

  private String regionId;

  private String signature;

  private String storageType;

  private String url;

  /**
   * 对象存储的access_key_id */
  public String getAccessKeyId() {
    return this.accessKeyId;
  }

  /**
   * 对象存储的access_key_id */
  public void setAccessKeyId(String accessKeyId) {
    this.accessKeyId = accessKeyId;
  }

  /**
   * 上传的目标bucket名称 */
  public String getBucket() {
    return this.bucket;
  }

  /**
   * 上传的目标bucket名称 */
  public void setBucket(String bucket) {
    this.bucket = bucket;
  }

  /**
   * 加密策略，仅storage_type为SYSTEM_OSS时有效 */
  public String getEncodedPolicy() {
    return this.encodedPolicy;
  }

  /**
   * 加密策略，仅storage_type为SYSTEM_OSS时有效 */
  public void setEncodedPolicy(String encodedPolicy) {
    this.encodedPolicy = encodedPolicy;
  }

  /**
   * 文件失效的日期时间 */
  public Date getExpiration() {
    return this.expiration;
  }

  /**
   * 文件失效的日期时间 */
  public void setExpiration(Date expiration) {
    this.expiration = expiration;
  }

  /**
   * 对象存储的上传目标文件路径 */
  public String getFilePath() {
    return this.filePath;
  }

  /**
   * 对象存储的上传目标文件路径 */
  public void setFilePath(String filePath) {
    this.filePath = filePath;
  }

  /**
   * 上传的目标主机名，仅storage_type为SYSTEM_OSS时有效 */
  public String getHost() {
    return this.host;
  }

  /**
   * 上传的目标主机名，仅storage_type为SYSTEM_OSS时有效 */
  public void setHost(String host) {
    this.host = host;
  }

  /**
   * 地域ID */
  public String getRegionId() {
    return this.regionId;
  }

  /**
   * 地域ID */
  public void setRegionId(String regionId) {
    this.regionId = regionId;
  }

  /**
   * 签名，仅storage_type为SYSTEM_OSS时有效 */
  public String getSignature() {
    return this.signature;
  }

  /**
   * 签名，仅storage_type为SYSTEM_OSS时有效 */
  public void setSignature(String signature) {
    this.signature = signature;
  }

  /**
   * 取值如下：
   * SYSTEM_AFS: 表示AFS存储
   * SYSTEM_OSS: 表示OSS存储 */
  public String getStorageType() {
    return this.storageType;
  }

  /**
   * 取值如下：
   * SYSTEM_AFS: 表示AFS存储
   * SYSTEM_OSS: 表示OSS存储 */
  public void setStorageType(String storageType) {
    this.storageType = storageType;
  }

  /**
   * 上传的目标URL */
  public String getUrl() {
    return this.url;
  }

  /**
   * 上传的目标URL */
  public void setUrl(String url) {
    this.url = url;
  }
}
