//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.model;

import java.lang.Long;
import java.lang.String;
import java.util.List;

/**
 * 状态详情 */
public class StatusDetail {
  private Long computeInstanceCount;

  private List<String> failureMessages;

  private String status;

  /**
   * 处于该状态的计算实例数 */
  public Long getComputeInstanceCount() {
    return this.computeInstanceCount;
  }

  /**
   * 处于该状态的计算实例数 */
  public void setComputeInstanceCount(Long computeInstanceCount) {
    this.computeInstanceCount = computeInstanceCount;
  }

  /**
   * 错误信息 */
  public List<String> getFailureMessages() {
    return this.failureMessages;
  }

  /**
   * 错误信息 */
  public void setFailureMessages(List<String> failureMessages) {
    this.failureMessages = failureMessages;
  }

  /**
   * 状态，只读，可枚举常量：
   * PENDING：挂起，计算资源正在被调度
   * NOT_READY：运行时或用户代码正在加载，checkService尚未通过
   * HEALTHY：健康，即checkService检查处于通过状态
   * USER_CODE_ERROR：用户代码或自身镜像问题导致checkService不通过
   * SAS_INTERNAL_ERROR：其它能探查出的内部问题导致错误
   * UNHEALTHY：原本成功通过checkService的计算实例，checkService不通过，即用户应用运行过程中出现问题 */
  public String getStatus() {
    return this.status;
  }

  /**
   * 状态，只读，可枚举常量：
   * PENDING：挂起，计算资源正在被调度
   * NOT_READY：运行时或用户代码正在加载，checkService尚未通过
   * HEALTHY：健康，即checkService检查处于通过状态
   * USER_CODE_ERROR：用户代码或自身镜像问题导致checkService不通过
   * SAS_INTERNAL_ERROR：其它能探查出的内部问题导致错误
   * UNHEALTHY：原本成功通过checkService的计算实例，checkService不通过，即用户应用运行过程中出现问题 */
  public void setStatus(String status) {
    this.status = status;
  }
}
