//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.model;

import java.lang.Long;
import java.lang.String;
import java.util.Date;
import java.util.List;

/**
 * 应用实例版本详细信息 */
public class ServerlessAppServiceVersionDetailInfo {
  private String appName;

  private String appServiceName;

  private String buildMode;

  private CheckService checkService;

  private String codeImageUrl;

  private CodePackage codePackage;

  private String cpu;

  private Long cpuOversoldRatio;

  private Date creationTime;

  private String creatorId;

  private List<EnvironmentVariable> customVariables;

  private String description;

  private Long disk;

  private String entryPoint;

  private String executionMode;

  private Long expiredAfter;

  private String fullVersion;

  private String maxAverageCpuUtilizationPercent;

  private String maxAverageMemUtilizationPercent;

  private String maxAverageQps;

  private Long maxComputeInstance;

  private Long maxConcurrentConnections;

  private Long maxResponseTimeInMs;

  private Long memory;

  private String minAverageCpuUtilizationPercent;

  private String minAverageMemUtilizationPercent;

  private String minAverageQps;

  private Long minComputeInstance;

  private Long minConcurrentConnections;

  private Long minResponseTimeInMs;

  private String readableCpu;

  private String readableDisk;

  private String readableMemory;

  private String routePercent;

  private Long routeWeight;

  private String runtimeFullVersion;

  private String runtimeIdentity;

  private List<EnvironmentVariable> runtimeVariables;

  private Long servicePort;

  private String specIdentity;

  private String status;

  private List<StatusDetail> statusDetails;

  private String techstackIdentity;

  private String techstackName;

  private String tenant;

  private Long totalComputeInstance;

  private Date updateTime;

  private String workspace;

  /**
   * 应用名称 */
  public String getAppName() {
    return this.appName;
  }

  /**
   * 应用名称 */
  public void setAppName(String appName) {
    this.appName = appName;
  }

  /**
   * 应用实例名称 */
  public String getAppServiceName() {
    return this.appServiceName;
  }

  /**
   * 应用实例名称 */
  public void setAppServiceName(String appServiceName) {
    this.appServiceName = appServiceName;
  }

  /**
   * 构建模式，取值如下：
   * IMAGE：镜像模式运行。
   * CODE_PACKAGE：代码包模式运行。继承应用实例的构建模式 */
  public String getBuildMode() {
    return this.buildMode;
  }

  /**
   * 构建模式，取值如下：
   * IMAGE：镜像模式运行。
   * CODE_PACKAGE：代码包模式运行。继承应用实例的构建模式 */
  public void setBuildMode(String buildMode) {
    this.buildMode = buildMode;
  }

  /**
   * 服务检查 */
  public CheckService getCheckService() {
    return this.checkService;
  }

  /**
   * 服务检查 */
  public void setCheckService(CheckService checkService) {
    this.checkService = checkService;
  }

  /**
   * 代码镜像 url
   */
  public String getCodeImageUrl() {
    return this.codeImageUrl;
  }

  /**
   * 代码镜像 url
   */
  public void setCodeImageUrl(String codeImageUrl) {
    this.codeImageUrl = codeImageUrl;
  }

  /**
   * 代码包信息 */
  public CodePackage getCodePackage() {
    return this.codePackage;
  }

  /**
   * 代码包信息 */
  public void setCodePackage(CodePackage codePackage) {
    this.codePackage = codePackage;
  }

  /**
   * cpu规格(冗余规格中的cpu) */
  public String getCpu() {
    return this.cpu;
  }

  /**
   * cpu规格(冗余规格中的cpu) */
  public void setCpu(String cpu) {
    this.cpu = cpu;
  }

  /**
   * cpu超卖比 */
  public Long getCpuOversoldRatio() {
    return this.cpuOversoldRatio;
  }

  /**
   * cpu超卖比 */
  public void setCpuOversoldRatio(Long cpuOversoldRatio) {
    this.cpuOversoldRatio = cpuOversoldRatio;
  }

  /**
   * 版本创建时间 */
  public Date getCreationTime() {
    return this.creationTime;
  }

  /**
   * 版本创建时间 */
  public void setCreationTime(Date creationTime) {
    this.creationTime = creationTime;
  }

  /**
   * 创建人ID */
  public String getCreatorId() {
    return this.creatorId;
  }

  /**
   * 创建人ID */
  public void setCreatorId(String creatorId) {
    this.creatorId = creatorId;
  }

  /**
   * 自定义环境变量 */
  public List<EnvironmentVariable> getCustomVariables() {
    return this.customVariables;
  }

  /**
   * 自定义环境变量 */
  public void setCustomVariables(List<EnvironmentVariable> customVariables) {
    this.customVariables = customVariables;
  }

  /**
   * 版本描述 */
  public String getDescription() {
    return this.description;
  }

  /**
   * 版本描述 */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * disk规格(冗余规格中的disk)
   * 单位: byte
   */
  public Long getDisk() {
    return this.disk;
  }

  /**
   * disk规格(冗余规格中的disk)
   * 单位: byte
   */
  public void setDisk(Long disk) {
    this.disk = disk;
  }

  /**
   * 入口函数或方法 */
  public String getEntryPoint() {
    return this.entryPoint;
  }

  /**
   * 入口函数或方法 */
  public void setEntryPoint(String entryPoint) {
    this.entryPoint = entryPoint;
  }

  /**
   * 执行模式 */
  public String getExecutionMode() {
    return this.executionMode;
  }

  /**
   * 执行模式 */
  public void setExecutionMode(String executionMode) {
    this.executionMode = executionMode;
  }

  /**
   * 流量比时0时, 隔多久自动删除这个版本
   * 单位: 小时 */
  public Long getExpiredAfter() {
    return this.expiredAfter;
  }

  /**
   * 流量比时0时, 隔多久自动删除这个版本
   * 单位: 小时 */
  public void setExpiredAfter(Long expiredAfter) {
    this.expiredAfter = expiredAfter;
  }

  /**
   * 版本号 */
  public String getFullVersion() {
    return this.fullVersion;
  }

  /**
   * 版本号 */
  public void setFullVersion(String fullVersion) {
    this.fullVersion = fullVersion;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大CPU使用率，当平均CPU使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选 */
  public String getMaxAverageCpuUtilizationPercent() {
    return this.maxAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大CPU使用率，当平均CPU使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选 */
  public void setMaxAverageCpuUtilizationPercent(String maxAverageCpuUtilizationPercent) {
    this.maxAverageCpuUtilizationPercent = maxAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大内存使用率，当平均内存使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选 */
  public String getMaxAverageMemUtilizationPercent() {
    return this.maxAverageMemUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大内存使用率，当平均内存使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选 */
  public void setMaxAverageMemUtilizationPercent(String maxAverageMemUtilizationPercent) {
    this.maxAverageMemUtilizationPercent = maxAverageMemUtilizationPercent;
  }

  /**
   * 实际为Double类型。平均每个实例可服务的最大QPS（Query Per Second，平均每秒请求数），超过该值会触发该服务版本的自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选 */
  public String getMaxAverageQps() {
    return this.maxAverageQps;
  }

  /**
   * 实际为Double类型。平均每个实例可服务的最大QPS（Query Per Second，平均每秒请求数），超过该值会触发该服务版本的自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选 */
  public void setMaxAverageQps(String maxAverageQps) {
    this.maxAverageQps = maxAverageQps;
  }

  /**
   * 最大计算实例. 当前版本的最多拥有的实例数 */
  public Long getMaxComputeInstance() {
    return this.maxComputeInstance;
  }

  /**
   * 最大计算实例. 当前版本的最多拥有的实例数 */
  public void setMaxComputeInstance(Long maxComputeInstance) {
    this.maxComputeInstance = maxComputeInstance;
  }

  /**
   * 平均每个计算实例可同时存在的并发连接数，精度到秒，超过该值会触发该服务版本的自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选，模板作用，新建应用服务版本不传会默认继承于此 */
  public Long getMaxConcurrentConnections() {
    return this.maxConcurrentConnections;
  }

  /**
   * 平均每个计算实例可同时存在的并发连接数，精度到秒，超过该值会触发该服务版本的自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选，模板作用，新建应用服务版本不传会默认继承于此 */
  public void setMaxConcurrentConnections(Long maxConcurrentConnections) {
    this.maxConcurrentConnections = maxConcurrentConnections;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最大平均响应时间，当平均请求响应时间超过该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选 */
  public Long getMaxResponseTimeInMs() {
    return this.maxResponseTimeInMs;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最大平均响应时间，当平均请求响应时间超过该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选 */
  public void setMaxResponseTimeInMs(Long maxResponseTimeInMs) {
    this.maxResponseTimeInMs = maxResponseTimeInMs;
  }

  /**
   * memory规格(冗余规格中的memory) 
   * 单位: byte */
  public Long getMemory() {
    return this.memory;
  }

  /**
   * memory规格(冗余规格中的memory) 
   * 单位: byte */
  public void setMemory(Long memory) {
    this.memory = memory;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小CPU使用率，当平均CPU使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选 */
  public String getMinAverageCpuUtilizationPercent() {
    return this.minAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小CPU使用率，当平均CPU使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选 */
  public void setMinAverageCpuUtilizationPercent(String minAverageCpuUtilizationPercent) {
    this.minAverageCpuUtilizationPercent = minAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小内存使用率，当平均内存使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选 */
  public String getMinAverageMemUtilizationPercent() {
    return this.minAverageMemUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小内存使用率，当平均内存使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选 */
  public void setMinAverageMemUtilizationPercent(String minAverageMemUtilizationPercent) {
    this.minAverageMemUtilizationPercent = minAverageMemUtilizationPercent;
  }

  /**
   * 实际为Double类型。平均每个实例可服务的最小QPS（Query Per Second，平均每秒请求数），小于该值会触发该服务版本的自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选 */
  public String getMinAverageQps() {
    return this.minAverageQps;
  }

  /**
   * 实际为Double类型。平均每个实例可服务的最小QPS（Query Per Second，平均每秒请求数），小于该值会触发该服务版本的自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选 */
  public void setMinAverageQps(String minAverageQps) {
    this.minAverageQps = minAverageQps;
  }

  /**
   * 该版本在无流量访问时保持的最小实例数目 */
  public Long getMinComputeInstance() {
    return this.minComputeInstance;
  }

  /**
   * 该版本在无流量访问时保持的最小实例数目 */
  public void setMinComputeInstance(Long minComputeInstance) {
    this.minComputeInstance = minComputeInstance;
  }

  /**
   * 平均每个计算实例可同时存在的并发连接数，精度到秒，小于该值会触发该服务版本的自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选，模板作用，新建应用服务版本不传会默认继承于此 */
  public Long getMinConcurrentConnections() {
    return this.minConcurrentConnections;
  }

  /**
   * 平均每个计算实例可同时存在的并发连接数，精度到秒，小于该值会触发该服务版本的自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选，模板作用，新建应用服务版本不传会默认继承于此 */
  public void setMinConcurrentConnections(Long minConcurrentConnections) {
    this.minConcurrentConnections = minConcurrentConnections;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最小平均响应时间，当平均请求响应时间小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选 */
  public Long getMinResponseTimeInMs() {
    return this.minResponseTimeInMs;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最小平均响应时间，当平均请求响应时间小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选 */
  public void setMinResponseTimeInMs(Long minResponseTimeInMs) {
    this.minResponseTimeInMs = minResponseTimeInMs;
  }

  /**
   * cpu可读化字符串表示 */
  public String getReadableCpu() {
    return this.readableCpu;
  }

  /**
   * cpu可读化字符串表示 */
  public void setReadableCpu(String readableCpu) {
    this.readableCpu = readableCpu;
  }

  /**
   * 磁盘可读化字符串表示 */
  public String getReadableDisk() {
    return this.readableDisk;
  }

  /**
   * 磁盘可读化字符串表示 */
  public void setReadableDisk(String readableDisk) {
    this.readableDisk = readableDisk;
  }

  /**
   * 内存可读化字符串表示 */
  public String getReadableMemory() {
    return this.readableMemory;
  }

  /**
   * 内存可读化字符串表示 */
  public void setReadableMemory(String readableMemory) {
    this.readableMemory = readableMemory;
  }

  /**
   * 版本流量百分比. 
   * 范围: 0-100 */
  public String getRoutePercent() {
    return this.routePercent;
  }

  /**
   * 版本流量百分比. 
   * 范围: 0-100 */
  public void setRoutePercent(String routePercent) {
    this.routePercent = routePercent;
  }

  /**
   * 版本的权重绝对值，整数，大于等于0，必填，可修改 */
  public Long getRouteWeight() {
    return this.routeWeight;
  }

  /**
   * 版本的权重绝对值，整数，大于等于0，必填，可修改 */
  public void setRouteWeight(Long routeWeight) {
    this.routeWeight = routeWeight;
  }

  /**
   * 运行时版本 */
  public String getRuntimeFullVersion() {
    return this.runtimeFullVersion;
  }

  /**
   * 运行时版本 */
  public void setRuntimeFullVersion(String runtimeFullVersion) {
    this.runtimeFullVersion = runtimeFullVersion;
  }

  /**
   * 运行时标识 */
  public String getRuntimeIdentity() {
    return this.runtimeIdentity;
  }

  /**
   * 运行时标识 */
  public void setRuntimeIdentity(String runtimeIdentity) {
    this.runtimeIdentity = runtimeIdentity;
  }

  /**
   * 运行时环境变量 */
  public List<EnvironmentVariable> getRuntimeVariables() {
    return this.runtimeVariables;
  }

  /**
   * 运行时环境变量 */
  public void setRuntimeVariables(List<EnvironmentVariable> runtimeVariables) {
    this.runtimeVariables = runtimeVariables;
  }

  /**
   * 服务端口 */
  public Long getServicePort() {
    return this.servicePort;
  }

  /**
   * 服务端口 */
  public void setServicePort(Long servicePort) {
    this.servicePort = servicePort;
  }

  /**
   * 规格标识 */
  public String getSpecIdentity() {
    return this.specIdentity;
  }

  /**
   * 规格标识 */
  public void setSpecIdentity(String specIdentity) {
    this.specIdentity = specIdentity;
  }

  /**
   * 只读，可空（如未发生实际访问），可枚举常量：
   * NORMAL：正常
   * ERROR：不正常，有问题 */
  public String getStatus() {
    return this.status;
  }

  /**
   * 只读，可空（如未发生实际访问），可枚举常量：
   * NORMAL：正常
   * ERROR：不正常，有问题 */
  public void setStatus(String status) {
    this.status = status;
  }

  /**
   * 计算实例状态细节 */
  public List<StatusDetail> getStatusDetails() {
    return this.statusDetails;
  }

  /**
   * 计算实例状态细节 */
  public void setStatusDetails(List<StatusDetail> statusDetails) {
    this.statusDetails = statusDetails;
  }

  /**
   * 版本使用的技术栈标识(冗余应用实例) */
  public String getTechstackIdentity() {
    return this.techstackIdentity;
  }

  /**
   * 版本使用的技术栈标识(冗余应用实例) */
  public void setTechstackIdentity(String techstackIdentity) {
    this.techstackIdentity = techstackIdentity;
  }

  /**
   * 版本使用的技术栈名称(冗余应用实例) */
  public String getTechstackName() {
    return this.techstackName;
  }

  /**
   * 版本使用的技术栈名称(冗余应用实例) */
  public void setTechstackName(String techstackName) {
    this.techstackName = techstackName;
  }

  /**
   * 租户名称 */
  public String getTenant() {
    return this.tenant;
  }

  /**
   * 租户名称 */
  public void setTenant(String tenant) {
    this.tenant = tenant;
  }

  /**
   * 只读，当前应用服务总的计算实例数 */
  public Long getTotalComputeInstance() {
    return this.totalComputeInstance;
  }

  /**
   * 只读，当前应用服务总的计算实例数 */
  public void setTotalComputeInstance(Long totalComputeInstance) {
    this.totalComputeInstance = totalComputeInstance;
  }

  /**
   * 版本修改时间 */
  public Date getUpdateTime() {
    return this.updateTime;
  }

  /**
   * 版本修改时间 */
  public void setUpdateTime(Date updateTime) {
    this.updateTime = updateTime;
  }

  /**
   * 该版本所属的环境标识 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 该版本所属的环境标识 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
