//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.model;

import java.lang.Long;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 日志索引 */
public class LogIndex {
  @NotNull
  private KeyValueIndex fullTextIndex;

  @NotNull
  private List<KeyValueIndex> keyValueIndices;

  private Long ttl;

  /**
   * 全文索引 */
  public KeyValueIndex getFullTextIndex() {
    return this.fullTextIndex;
  }

  /**
   * 全文索引 */
  public void setFullTextIndex(KeyValueIndex fullTextIndex) {
    this.fullTextIndex = fullTextIndex;
  }

  /**
   * 键值索引 */
  public List<KeyValueIndex> getKeyValueIndices() {
    return this.keyValueIndices;
  }

  /**
   * 键值索引 */
  public void setKeyValueIndices(List<KeyValueIndex> keyValueIndices) {
    this.keyValueIndices = keyValueIndices;
  }

  /**
   * ttl */
  public Long getTtl() {
    return this.ttl;
  }

  /**
   * ttl */
  public void setTtl(Long ttl) {
    this.ttl = ttl;
  }
}
