//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.model;

import java.lang.Long;
import java.lang.String;

/**
 * 服务检查 */
public class CheckService {
  private String execCommand;

  private Long failureThreshold;

  private String httpGetPath;

  private Long httpGetPort;

  private Long initialDelaySeconds;

  private Long periodSeconds;

  private Long successThreshold;

  private Long tcpSocketPort;

  private Long timeoutSeconds;

  /**
   * 健康检查: 执行命令 */
  public String getExecCommand() {
    return this.execCommand;
  }

  /**
   * 健康检查: 执行命令 */
  public void setExecCommand(String execCommand) {
    this.execCommand = execCommand;
  }

  /**
   * 不健康阈值.单位秒 */
  public Long getFailureThreshold() {
    return this.failureThreshold;
  }

  /**
   * 不健康阈值.单位秒 */
  public void setFailureThreshold(Long failureThreshold) {
    this.failureThreshold = failureThreshold;
  }

  /**
   * 健康检查: HTTP请求路径
   * 请求返回码介于200~400之间时，检查成功 */
  public String getHttpGetPath() {
    return this.httpGetPath;
  }

  /**
   * 健康检查: HTTP请求路径
   * 请求返回码介于200~400之间时，检查成功 */
  public void setHttpGetPath(String httpGetPath) {
    this.httpGetPath = httpGetPath;
  }

  /**
   * HTTP请求端口 */
  public Long getHttpGetPort() {
    return this.httpGetPort;
  }

  /**
   * HTTP请求端口 */
  public void setHttpGetPort(Long httpGetPort) {
    this.httpGetPort = httpGetPort;
  }

  /**
   * 首次检查延时
   * 单位秒 */
  public Long getInitialDelaySeconds() {
    return this.initialDelaySeconds;
  }

  /**
   * 首次检查延时
   * 单位秒 */
  public void setInitialDelaySeconds(Long initialDelaySeconds) {
    this.initialDelaySeconds = initialDelaySeconds;
  }

  /**
   * 检查间隔
   * 单位秒 */
  public Long getPeriodSeconds() {
    return this.periodSeconds;
  }

  /**
   * 检查间隔
   * 单位秒 */
  public void setPeriodSeconds(Long periodSeconds) {
    this.periodSeconds = periodSeconds;
  }

  /**
   * 健康阈值
   * 单位秒 */
  public Long getSuccessThreshold() {
    return this.successThreshold;
  }

  /**
   * 健康阈值
   * 单位秒 */
  public void setSuccessThreshold(Long successThreshold) {
    this.successThreshold = successThreshold;
  }

  /**
   * 健康检查: tcp端口检查
   * 当TCP端口被占用，检查成功 */
  public Long getTcpSocketPort() {
    return this.tcpSocketPort;
  }

  /**
   * 健康检查: tcp端口检查
   * 当TCP端口被占用，检查成功 */
  public void setTcpSocketPort(Long tcpSocketPort) {
    this.tcpSocketPort = tcpSocketPort;
  }

  /**
   * 检查超时
   * 单位秒 */
  public Long getTimeoutSeconds() {
    return this.timeoutSeconds;
  }

  /**
   * 检查超时
   * 单位秒 */
  public void setTimeoutSeconds(Long timeoutSeconds) {
    this.timeoutSeconds = timeoutSeconds;
  }
}
