//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.apidemo.v1_0.response;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderResponse;
import cn.com.antcloud.api.provider.apidemo.v1_0.model.DemoClass;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * Demo接口，返回当输入的值
 */
public class EchoGatewayCheckResponse extends AntCloudProviderResponse<EchoGatewayCheckResponse> {
  @NotNull
  private DemoClass outputDemo;

  @NotNull
  private String outputString;

  /**
   * 输入Demo类型 */
  public DemoClass getOutputDemo() {
    return this.outputDemo;
  }

  /**
   * 输入Demo类型 */
  public void setOutputDemo(DemoClass outputDemo) {
    this.outputDemo = outputDemo;
  }

  /**
   * 输入字符串参数 */
  public String getOutputString() {
    return this.outputString;
  }

  /**
   * 输入字符串参数 */
  public void setOutputString(String outputString) {
    this.outputString = outputString;
  }
}
