//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.apidemo.v1_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.apidemo.v1_0.model.AnotherClass;
import cn.com.antcloud.api.provider.apidemo.v1_0.model.DemoClass;
import cn.com.antcloud.api.provider.apidemo.v1_0.response.EchoGatewayCheckResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * Demo接口，返回当输入的值
 */
public class EchoGatewayCheckRequest extends AntCloudProviderRequest<EchoGatewayCheckResponse> {
  @NotNull
  private AnotherClass inputClass;

  @NotNull
  private DemoClass inputDemo;

  @NotNull
  private String inputString;

  public EchoGatewayCheckRequest() {
    super("antcloud.demo.gateway.check.echo", "1.0", "Java-SDK-20200727");
  }

  /**
   * 输入AnotherClass类型 */
  public AnotherClass getInputClass() {
    return this.inputClass;
  }

  /**
   * 输入AnotherClass类型 */
  public void setInputClass(AnotherClass inputClass) {
    this.inputClass = inputClass;
  }

  /**
   * 输入Demo类型 */
  public DemoClass getInputDemo() {
    return this.inputDemo;
  }

  /**
   * 输入Demo类型 */
  public void setInputDemo(DemoClass inputDemo) {
    this.inputDemo = inputDemo;
  }

  /**
   * 输入字符串参数 */
  public String getInputString() {
    return this.inputString;
  }

  /**
   * 输入字符串参数 */
  public void setInputString(String inputString) {
    this.inputString = inputString;
  }
}
