/*
 * Decompiled with CFR 0.152.
 */
package cn.appsdream.nestrefresh.normalstyle;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.appsdream.nestrefresh.base.AbsRefreshLayout;
import com.github.anzewei.pagelist.R;

public class NestHeader
extends RelativeLayout
implements AbsRefreshLayout.LoaderDecor {
    private ImageView mArrowImageView;
    private ProgressBar mProgressBar;
    private int mState = 0;
    private String mstrTitle;
    private Animation mRotateUpAnim;
    private Animation mRotateDownAnim;
    private final int ROTATE_ANIM_DURATION = 180;
    private TextPaint mPaint = new TextPaint();

    public NestHeader(Context context) {
        this(context, null);
    }

    public NestHeader(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NestHeader(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context, attrs, defStyle);
    }

    private void initView(Context context, AttributeSet attrs, int defStyle) {
        NestHeader.inflate((Context)context, (int)R.layout.pull_header, (ViewGroup)this);
        if (this.isInEditMode()) {
            return;
        }
        float scale = context.getResources().getDisplayMetrics().density;
        int padding = (int)(15.0f / scale + 0.5f);
        this.setPadding(0, padding, 0, padding);
        int[] attsRes = new int[]{R.attr.pullDrawable};
        TypedArray a = context.obtainStyledAttributes(attrs, attsRes, defStyle, R.style.pull_style);
        Drawable pullDrawable = a.getDrawable(0);
        a.recycle();
        this.mstrTitle = this.getResources().getString(R.string.loader_pull_load);
        this.mArrowImageView = (ImageView)this.findViewById(R.id.header_arrow);
        TextView hintText = (TextView)this.findViewById(R.id.header_hint);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.header_progressbar);
        this.mArrowImageView.setImageDrawable(pullDrawable);
        this.mPaint.setTextSize(hintText.getTextSize());
        this.mPaint.setColor(-16777216);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mPaint.setAntiAlias(true);
        this.mRotateUpAnim = new RotateAnimation(0.0f, -180.0f, 1, 0.5f, 1, 0.5f);
        this.mRotateUpAnim.setDuration(180L);
        this.mRotateUpAnim.setFillAfter(true);
        this.mRotateDownAnim = new RotateAnimation(-180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.mRotateDownAnim.setDuration(180L);
        this.mRotateDownAnim.setFillAfter(true);
    }

    @Override
    public void scrollRate(int y) {
    }

    @Override
    public void setState(int state) {
        if (state == this.mState) {
            return;
        }
        if (state == 2) {
            this.mArrowImageView.clearAnimation();
            this.mArrowImageView.setVisibility(8);
            this.mProgressBar.setVisibility(0);
        } else if (state == 5) {
            this.mArrowImageView.setVisibility(8);
            this.mProgressBar.setVisibility(8);
        } else {
            this.mArrowImageView.setVisibility(0);
            this.mProgressBar.setVisibility(8);
        }
        switch (state) {
            case 0: {
                if (this.mState == 1) {
                    this.mArrowImageView.startAnimation(this.mRotateDownAnim);
                } else if (this.mState == 2) {
                    this.mArrowImageView.clearAnimation();
                }
                this.mstrTitle = this.getResources().getString(R.string.loader_pull_load);
                break;
            }
            case 1: {
                if (this.mState == 1) break;
                this.mArrowImageView.clearAnimation();
                this.mArrowImageView.startAnimation(this.mRotateUpAnim);
                this.mstrTitle = this.getResources().getString(R.string.loader_pull_ready);
                break;
            }
            case 2: {
                this.mstrTitle = this.getResources().getString(R.string.loader_loading);
                break;
            }
            case 5: {
                this.mstrTitle = this.getResources().getString(R.string.loader_success);
                break;
            }
        }
        this.mState = state;
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mState == 2) {
            // empty if block
        }
        super.dispatchDraw(canvas);
        if (this.isInEditMode()) {
            return;
        }
        Paint.FontMetrics fontMetrics = this.mPaint.getFontMetrics();
        float fontHeight = fontMetrics.bottom - fontMetrics.top;
        float textBaseY = (float)this.getHeight() - ((float)this.getHeight() - fontHeight) / 2.0f - fontMetrics.bottom;
        canvas.drawText(this.mstrTitle, (float)(this.getWidth() / 2 + this.mArrowImageView.getMeasuredWidth()), textBaseY, (Paint)this.mPaint);
    }
}

