/*
 * Decompiled with CFR 0.152.
 */
package cn.appsdream.nestrefresh.matetialstyle;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import cn.appsdream.nestrefresh.base.AbsRefreshLayout;
import cn.appsdream.nestrefresh.matetialstyle.ProgressAnimationImageView;
import cn.appsdream.nestrefresh.matetialstyle.WaveView;
import com.github.anzewei.pagelist.R;

public class MaterialRefreshLayout
extends AbsRefreshLayout {
    private DecelerateInterpolator mDecelerateInterpolator;
    private WaveView mWaveView;
    private ProgressAnimationImageView mCircleView;
    private static final int DEFAULT_CIRCLE_BG_LIGHT = -14575885;
    private static final int DEFAULT_PG_LIGHT = -1;
    private static final int SCALE_DOWN_DURATION = 200;
    private static final float MAX_PROGRESS_ROTATION_RATE = 0.8f;
    private static final int ANIMATE_TO_TRIGGER_DURATION = 200;
    private static final int DEFAULT_CIRCLE_TARGET = 64;
    private static final float DECELERATE_INTERPOLATION_FACTOR = 2.0f;
    private static final float DRAGGING_WEIGHT = 0.5f;
    private final Animation mAnimateToCorrectPosition = new Animation(){

        public void applyTransformation(float interpolatedTime, @NonNull Transformation t) {
        }
    };
    private Animation.AnimationListener mRefreshListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            if (MaterialRefreshLayout.this.isRefreshing()) {
                MaterialRefreshLayout.this.mCircleView.makeProgressTransparent();
                MaterialRefreshLayout.this.mCircleView.startProgress();
            } else {
                MaterialRefreshLayout.this.mCircleView.stopProgress();
                MaterialRefreshLayout.this.mCircleView.setVisibility(8);
                MaterialRefreshLayout.this.mCircleView.makeProgressTransparent();
                MaterialRefreshLayout.this.mWaveView.startDisappearCircleAnimation();
            }
        }
    };

    public MaterialRefreshLayout(Context context) {
        this(context, null);
    }

    public MaterialRefreshLayout(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.materiaProgressBarStyle);
    }

    public MaterialRefreshLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    public MaterialRefreshLayout(View listView) {
        super(listView);
        this.init(listView.getContext(), null, R.attr.materiaProgressBarStyle);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mDecelerateInterpolator = new DecelerateInterpolator(2.0f);
        this.createWaveView();
        this.createProgressView();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MateriaProgressBar, defStyleAttr, 0);
        this.setWaveColor(a.getColor(R.styleable.MateriaProgressBar_mlpb_background_color, -14575885));
        this.setColorSchemeColors(a.getColor(R.styleable.MateriaProgressBar_mlpb_progress_color, -1));
        a.recycle();
    }

    private void createProgressView() {
        this.mCircleView = new ProgressAnimationImageView(this.getContext());
        this.mCircleView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.setHeaderView((View)this.mCircleView);
    }

    private void createWaveView() {
        this.mWaveView = new WaveView(this.getContext());
        this.mWaveView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.addView(this.mWaveView);
        this.mWaveView.setmDropListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (MaterialRefreshLayout.this.isRefreshing()) {
                    MaterialRefreshLayout.this.invokeRefresh();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    @Override
    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        if (this.mWaveView == this.mTargetView) {
            this.mTargetView = null;
        }
        if (child == this.mTargetView) {
            this.removeViewInLayout(this.mTargetView);
            super.addView(this.mTargetView, 0, params);
        }
    }

    @Override
    protected boolean offsetLayout(float diffY) {
        if (this.getOffsetY() > 0 && this.getScrollY() == 0) {
            this.offsetWave(this.getOffsetY());
            return true;
        }
        return super.offsetLayout(diffY);
    }

    private void offsetWave(float diffY) {
        float overScrollTop = diffY * 0.5f;
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        float originalDragPercent = overScrollTop / (64.0f * metrics.density);
        float dragPercent = Math.min(1.0f, originalDragPercent);
        float adjustedPercent = (float)Math.max((double)dragPercent - 0.4, 0.0) * 5.0f / 3.0f;
        float tensionSlingshotPercent = originalDragPercent > 3.0f ? 2.0f : (originalDragPercent > 1.0f ? originalDragPercent - 1.0f : 0.0f);
        float tensionPercent = (4.0f - tensionSlingshotPercent) * tensionSlingshotPercent / 8.0f;
        this.mCircleView.showArrow(true);
        this.reInitCircleView();
        if (originalDragPercent < 1.0f) {
            float strokeStart = adjustedPercent * 0.8f;
            this.mCircleView.setProgressStartEndTrim(0.0f, Math.min(0.8f, strokeStart));
            this.mCircleView.setArrowScale(Math.min(1.0f, adjustedPercent));
        }
        float rotation = (-0.25f + 0.4f * adjustedPercent + tensionPercent * 2.0f) * 0.5f;
        this.mCircleView.setProgressRotation(rotation);
        this.mCircleView.setTranslationY(this.mWaveView.getCurrentCircleCenterY());
        float seed = diffY / (float)Math.min(this.getMeasuredWidth(), this.getMeasuredHeight());
        float firstBounds = seed * (5.0f - 2.0f * seed) / 3.5f;
        float secondBounds = firstBounds - VERTICAL_DRAG_THRESHOLD.FIRST.val;
        float finalBounds = (firstBounds - VERTICAL_DRAG_THRESHOLD.SECOND.val) / 5.0f;
        if (firstBounds < VERTICAL_DRAG_THRESHOLD.FIRST.val) {
            this.onBeginPhase(firstBounds);
        } else if (firstBounds < VERTICAL_DRAG_THRESHOLD.SECOND.val) {
            this.onAppearPhase(firstBounds, secondBounds);
        } else if (firstBounds < VERTICAL_DRAG_THRESHOLD.THIRD.val) {
            this.onExpandPhase(firstBounds, secondBounds, finalBounds);
        } else {
            this.onDropPhase();
        }
    }

    private void onBeginPhase(float move1) {
        this.mWaveView.beginPhase(move1);
    }

    private void onAppearPhase(float move1, float move2) {
        this.mWaveView.appearPhase(move1, move2);
    }

    private void onExpandPhase(float move1, float move2, float move3) {
        this.mWaveView.expandPhase(move1, move2, move3);
    }

    private void onDropPhase() {
        this.mWaveView.animationDropCircle();
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
        animator.setDuration(500L);
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                MaterialRefreshLayout.this.mCircleView.setTranslationY(MaterialRefreshLayout.this.mWaveView.getCurrentCircleCenterY() + (float)MaterialRefreshLayout.this.mCircleView.getHeight() / 2.0f);
            }
        });
        animator.start();
        this.setRefreshing(true);
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        int top = 0;
        if (this.mTargetView != null) {
            this.mTargetView.layout(0, top, this.mTargetView.getMeasuredWidth(), this.mTargetView.getMeasuredHeight() + top);
        }
        if (this.mWaveView != null) {
            this.mWaveView.layout(0, 0, this.mWaveView.getMeasuredWidth(), this.mWaveView.getMeasuredHeight());
        }
        if (this.mFooterView != null) {
            this.mFooterView.layout(0, this.getMeasuredHeight() + top, this.mFooterView.getMeasuredWidth(), this.getMeasuredHeight() + this.mFooterView.getMeasuredHeight() + top);
        }
        int circleWidth = this.mCircleView.getMeasuredWidth();
        int circleHeight = this.mCircleView.getMeasuredHeight();
        this.mCircleView.layout((this.getMeasuredWidth() - circleWidth) / 2, -circleHeight, (this.getMeasuredWidth() + circleWidth) / 2, 0);
    }

    @Override
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (this.isRefreshing() || this.isLoadingMore()) {
            return false;
        }
        return super.onTouchEvent(event);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.isRefreshing() || this.isLoadingMore()) {
            return true;
        }
        return super.onInterceptTouchEvent(event);
    }

    @Override
    public void setRefreshing(boolean refresh) {
        if (this.isRefreshing() != refresh) {
            super.setRefreshing(refresh);
            if (this.isRefreshing()) {
                this.animateOffsetToCorrectPosition();
            } else {
                this.startScaleDownAnimation(this.mRefreshListener);
            }
        }
    }

    @Override
    public void showLoading() {
        this.mWaveView.manualRefresh();
        this.reInitCircleView();
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
        animator.setDuration(500L);
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                MaterialRefreshLayout.this.mCircleView.setTranslationY(MaterialRefreshLayout.this.mWaveView.getCurrentCircleCenterY() + (float)MaterialRefreshLayout.this.mCircleView.getHeight() / 2.0f);
            }
        });
        animator.start();
        this.setRefreshing(true);
    }

    private void reInitCircleView() {
        if (this.mCircleView.getVisibility() != 0) {
            this.mCircleView.setVisibility(0);
        }
        this.mCircleView.scaleWithKeepingAspectRatio(1.0f);
        this.mCircleView.makeProgressTransparent();
    }

    @Override
    protected void touchUp(MotionEvent event) {
        if (this.getScrollY() != 0) {
            super.touchUp(event);
            this.mWaveView.startWaveAnimation(0.0f);
        } else if (this.isRefreshEnable()) {
            switch (event.getAction()) {
                case 1: {
                    float diffY = event.getY() - this.mFirstTouchDownPointY;
                    float waveHeightThreshold = diffY * (3.0f - 2.0f * diffY / (float)Math.min(this.getMeasuredWidth(), this.getMeasuredHeight())) / 1000.0f;
                    this.mWaveView.startWaveAnimation(waveHeightThreshold);
                }
                case 3: {
                    if (this.isRefreshing()) break;
                    this.mCircleView.setProgressStartEndTrim(0.0f, 0.0f);
                    this.mCircleView.showArrow(false);
                    this.mCircleView.setVisibility(8);
                }
            }
        }
    }

    private void animateOffsetToCorrectPosition() {
        this.animateOffsetToCorrectPosition(this.mRefreshListener);
    }

    private void animateOffsetToCorrectPosition(Animation.AnimationListener listener) {
        this.mAnimateToCorrectPosition.reset();
        this.mAnimateToCorrectPosition.setDuration(200L);
        this.mAnimateToCorrectPosition.setInterpolator((Interpolator)this.mDecelerateInterpolator);
        if (listener != null) {
            this.mCircleView.setAnimationListener(listener);
        }
        this.mCircleView.clearAnimation();
        this.mCircleView.startAnimation(this.mAnimateToCorrectPosition);
    }

    public void setMaxDropHeight(int dropHeight) {
        this.mWaveView.setMaxDropHeight(dropHeight);
    }

    private void startScaleDownAnimation(Animation.AnimationListener listener) {
        Animation scaleDownAnimation = new Animation(){

            public void applyTransformation(float interpolatedTime, Transformation t) {
                MaterialRefreshLayout.this.mCircleView.scaleWithKeepingAspectRatio(1.0f - interpolatedTime);
            }
        };
        scaleDownAnimation.setDuration(200L);
        this.mCircleView.setAnimationListener(listener);
        this.mCircleView.clearAnimation();
        this.mCircleView.startAnimation(scaleDownAnimation);
    }

    public void setColorSchemeResources(int ... colorResIds) {
        Resources res = this.getResources();
        int[] colorRes = new int[colorResIds.length];
        for (int i = 0; i < colorResIds.length; ++i) {
            colorRes[i] = res.getColor(colorResIds[i]);
        }
        this.setColorSchemeColors(colorRes);
    }

    public void setColorSchemeColors(int ... colors) {
        this.mCircleView.setProgressColorSchemeColors(colors);
    }

    public void setShadowRadius(int radius) {
        radius = Math.max(0, radius);
        this.mWaveView.setShadowRadius(radius);
    }

    public void setWaveColor(int color) {
        this.mWaveView.setWaveColor(color);
    }

    @Override
    protected boolean IsBeingDropped() {
        return this.isRefreshing();
    }

    private static enum VERTICAL_DRAG_THRESHOLD {
        FIRST(0.1f),
        SECOND(0.16f + VERTICAL_DRAG_THRESHOLD.FIRST.val),
        THIRD(0.5f + VERTICAL_DRAG_THRESHOLD.FIRST.val);

        final float val;

        private VERTICAL_DRAG_THRESHOLD(float val) {
            this.val = val;
        }
    }
}

