/*
 * Decompiled with CFR 0.152.
 */
package cn.appsdream.nestrefresh.matetialstyle;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.net.Uri;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.widget.ImageView;
import cn.appsdream.nestrefresh.matetialstyle.MaterialProgressDrawable;
import cn.appsdream.nestrefresh.util.DisplayUtil;
import com.github.anzewei.pagelist.R;

public class MateriaProgressBar
extends ImageView {
    private static final int KEY_SHADOW_COLOR = 0x1E000000;
    private static final int FILL_SHADOW_COLOR = 0x3D000000;
    private static final float X_OFFSET = 0.0f;
    private static final float Y_OFFSET = 1.75f;
    private static final float SHADOW_RADIUS = 3.5f;
    private static final int SHADOW_ELEVATION = 4;
    private static final int DEFAULT_CIRCLE_BG_LIGHT = -328966;
    private static final int DEFAULT_CIRCLE_DIAMETER = 50;
    private static final int STROKE_WIDTH_LARGE = 2;
    public static final int DEFAULT_TEXT_SIZE = 9;
    private Animation.AnimationListener mListener;
    private int mShadowRadius;
    private int mBackGroundColor;
    private int mProgressColor;
    private int mProgressStokeWidth;
    private int mArrowWidth;
    private int mArrowHeight;
    private int mProgress;
    private int mMax;
    private int mDiameter;
    private int mInnerRadius;
    private Paint mTextPaint;
    private int mTextColor;
    private int mTextSize;
    private boolean mIfDrawText;
    private boolean mShowArrow;
    private MaterialProgressDrawable mProgressDrawable;
    private ShapeDrawable mBgCircle;
    private boolean mCircleBackgroundEnabled;
    private int[] mColors = new int[]{-16777216};

    public MateriaProgressBar(Context context) {
        super(context);
        this.init(context, null, R.attr.materiaProgressBarStyle);
    }

    public MateriaProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, R.attr.materiaProgressBarStyle);
    }

    public MateriaProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MateriaProgressBar, defStyleAttr, 0);
        float density = this.getContext().getResources().getDisplayMetrics().density;
        this.mBackGroundColor = a.getColor(R.styleable.MateriaProgressBar_mlpb_background_color, -328966);
        this.mProgressColor = a.getColor(R.styleable.MateriaProgressBar_mlpb_progress_color, -328966);
        this.mColors = new int[]{this.mProgressColor};
        this.mInnerRadius = a.getDimensionPixelOffset(R.styleable.MateriaProgressBar_mlpb_inner_radius, -1);
        this.mProgressStokeWidth = a.getDimensionPixelOffset(R.styleable.MateriaProgressBar_mlpb_progress_stoke_width, (int)(2.0f * density));
        this.mArrowWidth = a.getDimensionPixelOffset(R.styleable.MateriaProgressBar_mlpb_arrow_width, -1);
        this.mArrowHeight = a.getDimensionPixelOffset(R.styleable.MateriaProgressBar_mlpb_arrow_height, -1);
        this.mTextSize = a.getDimensionPixelOffset(R.styleable.MateriaProgressBar_mlpb_progress_text_size, (int)(9.0f * density));
        this.mTextColor = a.getColor(R.styleable.MateriaProgressBar_mlpb_progress_text_color, -16777216);
        this.mShowArrow = a.getBoolean(R.styleable.MateriaProgressBar_mlpb_show_arrow, false);
        this.mCircleBackgroundEnabled = a.getBoolean(R.styleable.MateriaProgressBar_mlpb_enable_circle_background, true);
        this.mProgress = a.getInt(R.styleable.MateriaProgressBar_mlpb_progress, 0);
        this.mMax = a.getInt(R.styleable.MateriaProgressBar_mlpb_max, 100);
        int textVisible = a.getInt(R.styleable.MateriaProgressBar_mlpb_progress_text_visibility, 1);
        if (textVisible != 1) {
            this.mIfDrawText = true;
        }
        this.mTextPaint = new Paint();
        this.mTextPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setColor(this.mTextColor);
        this.mTextPaint.setTextSize((float)this.mTextSize);
        this.mTextPaint.setAntiAlias(true);
        a.recycle();
        this.mProgressDrawable = new MaterialProgressDrawable(this.getContext(), (View)this);
        this.mDiameter = Math.min(this.getMeasuredWidth(), this.getMeasuredHeight());
        if (this.mDiameter <= 0) {
            this.mDiameter = (int)density * 50;
        }
        if (this.getBackground() == null && this.mCircleBackgroundEnabled) {
            int shadowYOffset = (int)(density * 1.75f);
            int shadowXOffset = (int)(density * 0.0f);
            this.mShadowRadius = (int)(density * 3.5f);
            if (this.elevationSupported()) {
                if (this.mBgCircle == null) {
                    this.mBgCircle = new ShapeDrawable((Shape)new OvalShape());
                }
                ViewCompat.setElevation((View)this, (float)(4.0f * density));
            } else if (this.mBgCircle == null) {
                OvalShadow oval = new OvalShadow(this.mShadowRadius, this.mDiameter - this.mShadowRadius * 2);
                this.mBgCircle = new ShapeDrawable((Shape)oval);
                ViewCompat.setLayerType((View)this, (int)1, (Paint)this.mBgCircle.getPaint());
                this.mBgCircle.getPaint().setShadowLayer((float)this.mShadowRadius, (float)shadowXOffset, (float)shadowYOffset, 0x1E000000);
                int padding = this.mShadowRadius;
                this.setPadding(padding, padding, padding, padding);
            }
            this.mBgCircle.getPaint().setColor(this.mBackGroundColor);
            this.setBackgroundDrawable((Drawable)this.mBgCircle);
        }
        this.mProgressDrawable.setBackgroundColor(this.mBackGroundColor);
        this.mProgressDrawable.setColorSchemeColors(this.mColors);
        this.mProgressDrawable.setSizeParameters(this.mDiameter, this.mDiameter, this.mInnerRadius <= 0 ? (double)((this.mDiameter - this.mProgressStokeWidth * 2) / 4) : (double)this.mInnerRadius, this.mProgressStokeWidth, this.mArrowWidth < 0 ? (float)(this.mProgressStokeWidth * 4) : (float)this.mArrowWidth, this.mArrowHeight < 0 ? (float)(this.mProgressStokeWidth * 2) : (float)this.mArrowHeight);
        if (this.isShowArrow()) {
            this.mProgressDrawable.showArrowOnFirstStart(true);
            this.mProgressDrawable.setArrowScale(1.0f);
            this.mProgressDrawable.showArrow(true);
        }
        this.mProgressDrawable.setAlpha(255);
        if (DisplayUtil.isOver600dp(this.getContext())) {
            this.mProgressDrawable.updateSizes(0);
        }
        super.setImageDrawable((Drawable)this.mProgressDrawable);
    }

    private boolean elevationSupported() {
        return Build.VERSION.SDK_INT >= 21;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.elevationSupported()) {
            this.setMeasuredDimension(this.getMeasuredWidth() + this.mShadowRadius * 2, this.getMeasuredHeight() + this.mShadowRadius * 2);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.getVisibility() == 0) {
            this.mProgressDrawable.start();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mIfDrawText) {
            String text = String.format("%s%%", this.mProgress);
            int x = this.getWidth() / 2 - text.length() * this.mTextSize / 4;
            int y = this.getHeight() / 2 + this.mTextSize / 4;
            canvas.drawText(text, (float)x, (float)y, this.mTextPaint);
        }
    }

    public final void setImageResource(int resId) {
    }

    public boolean isShowArrow() {
        return this.mShowArrow;
    }

    public void setShowArrow(boolean showArrow) {
        this.mShowArrow = showArrow;
    }

    public final void setImageURI(Uri uri) {
        super.setImageURI(uri);
    }

    public final void setImageDrawable(Drawable drawable) {
    }

    public void setAnimationListener(Animation.AnimationListener listener) {
        this.mListener = listener;
    }

    public void onAnimationStart() {
        super.onAnimationStart();
        if (this.mListener != null) {
            this.mListener.onAnimationStart(this.getAnimation());
        }
    }

    public void onAnimationEnd() {
        super.onAnimationEnd();
        if (this.mListener != null) {
            this.mListener.onAnimationEnd(this.getAnimation());
        }
    }

    public void setColorSchemeResources(int ... colorResIds) {
        Resources res = this.getResources();
        int[] colorRes = new int[colorResIds.length];
        for (int i = 0; i < colorResIds.length; ++i) {
            colorRes[i] = res.getColor(colorResIds[i]);
        }
        this.setColorSchemeColors(colorRes);
    }

    public void setColorSchemeColors(int ... colors) {
        this.mColors = colors;
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setColorSchemeColors(colors);
        }
    }

    public void setBackgroundColor(int colorRes) {
        if (this.getBackground() instanceof ShapeDrawable) {
            Resources res = this.getResources();
            ((ShapeDrawable)this.getBackground()).getPaint().setColor(res.getColor(colorRes));
        }
    }

    public boolean isShowProgressText() {
        return this.mIfDrawText;
    }

    public void setShowProgressText(boolean mIfDrawText) {
        this.mIfDrawText = mIfDrawText;
    }

    public int getMax() {
        return this.mMax;
    }

    public void setMax(int max) {
        this.mMax = max;
    }

    public int getProgress() {
        return this.mProgress;
    }

    public void setProgress(int progress) {
        if (this.getMax() > 0) {
            this.mProgress = progress;
        }
    }

    public boolean circleBackgroundEnabled() {
        return this.mCircleBackgroundEnabled;
    }

    public void setCircleBackgroundEnabled(boolean enableCircleBackground) {
        this.mCircleBackgroundEnabled = enableCircleBackground;
    }

    public int getVisibility() {
        return super.getVisibility();
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setVisible(visibility == 0, false);
            if (visibility != 0) {
                this.mProgressDrawable.stop();
            } else {
                if (this.mProgressDrawable.isRunning()) {
                    this.mProgressDrawable.stop();
                }
                this.mProgressDrawable.start();
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.stop();
            this.mProgressDrawable.setVisible(this.getVisibility() == 0, false);
            this.requestLayout();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.stop();
            this.mProgressDrawable.setVisible(false, false);
        }
    }

    private class OvalShadow
    extends OvalShape {
        private RadialGradient mRadialGradient;
        private static final int SHADOW_COLOR = -16777216;
        private int mShadowRadius;
        private Paint mShadowPaint = new Paint();
        private int mCircleDiameter;

        public OvalShadow(int shadowRadius, int circleDiameter) {
            this.mShadowRadius = shadowRadius;
            this.mCircleDiameter = circleDiameter;
            this.mRadialGradient = new RadialGradient((float)(this.mCircleDiameter / 2), (float)(this.mCircleDiameter / 2), (float)this.mShadowRadius, new int[]{0x3D000000, 0}, null, Shader.TileMode.CLAMP);
            this.mShadowPaint.setShader((Shader)this.mRadialGradient);
        }

        public void draw(Canvas canvas, Paint paint) {
            int viewWidth = MateriaProgressBar.this.getWidth();
            int viewHeight = MateriaProgressBar.this.getHeight();
            canvas.drawCircle((float)(viewWidth / 2), (float)(viewHeight / 2), (float)(this.mCircleDiameter / 2 + this.mShadowRadius), this.mShadowPaint);
            canvas.drawCircle((float)(viewWidth / 2), (float)(viewHeight / 2), (float)(this.mCircleDiameter / 2), paint);
        }
    }
}

