/*
 * Decompiled with CFR 0.152.
 */
package cn.appsdream.nestrefresh.base;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.appsdream.nestrefresh.base.AbsRefreshLayout;
import com.github.anzewei.pagelist.R;

public class NestFooter
extends RelativeLayout
implements AbsRefreshLayout.LoaderDecor {
    private static final String TAG = NestFooter.class.getSimpleName();
    private int mStatus = 0;
    private View mProgressBar;
    private TextView mHintView;

    public NestFooter(Context context) {
        super(context);
        this.initView(context);
    }

    public NestFooter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    @Override
    public void setState(int state) {
        if (state == this.mStatus) {
            return;
        }
        this.mStatus = state;
        Log.d((String)TAG, (String)("setState: " + state));
        if (state == 1) {
            this.mProgressBar.setVisibility(4);
            this.mHintView.setVisibility(0);
            this.mHintView.setText(R.string.loader_load_ready);
        } else if (state == 2) {
            this.mHintView.setVisibility(0);
            this.mProgressBar.setVisibility(0);
            this.mHintView.setText(R.string.loader_loading);
        } else if (state == 0) {
            this.mProgressBar.setVisibility(4);
            this.mHintView.setVisibility(0);
            this.mHintView.setText(R.string.loader_load_more);
        } else if (state == 4) {
            this.mProgressBar.setVisibility(4);
            this.mHintView.setVisibility(0);
            this.mHintView.setText(R.string.loader_no_more);
        } else {
            this.mHintView.setVisibility(8);
        }
    }

    private void initView(Context context) {
        NestFooter.inflate((Context)this.getContext(), (int)R.layout.pull_footer, (ViewGroup)this);
        this.mProgressBar = this.findViewById(R.id.footer_progressbar);
        this.mHintView = (TextView)this.findViewById(R.id.footer_hint_textview);
        float scale = context.getResources().getDisplayMetrics().density;
        int padding = (int)(10.0f / scale + 0.5f);
        this.setPadding(0, padding, 0, padding);
    }

    @Override
    public void scrollRate(int y) {
    }
}

