/*
 * Decompiled with CFR 0.152.
 */
package cn.appsdream.nestrefresh.base;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.Scroller;
import cn.appsdream.nestrefresh.base.OnPullListener;
import com.github.anzewei.pagelist.R;

public abstract class AbsRefreshLayout
extends ViewGroup
implements NestedScrollingChild,
NestedScrollingParent {
    private final int[] mParentOffsetInWindow = new int[2];
    private final int[] mParentScrollConsumed = new int[2];
    private NestedScrollingParentHelper mNestedScrollingParentHelper;
    private NestedScrollingChildHelper mNestedScrollingChildHelper;
    private boolean mNestedScrollInProgress;
    protected static final String TAG = AbsRefreshLayout.class.getSimpleName();
    private static final int INVALID_POINTER_ID = -1;
    protected static final int DROP_CIRCLE_ANIMATOR_DURATION = 200;
    private boolean mbLayout;
    private Scroller mScroller;
    protected View mEmptyView;
    protected View mTargetView;
    protected View mHeaderView;
    private boolean mbRefreshing;
    private boolean mbRefreshingInvoked = false;
    private boolean mEnableFresh = true;
    protected View mFooterView;
    private boolean mEnablePullLoad = true;
    private boolean mbLoadAll = false;
    private boolean mbLoading;
    private boolean mbLoadingInvoked = false;
    private OnPullListener mLoadListener;
    private int mActivePointerId;
    protected float mFirstTouchDownPointY;
    private int mTotalOffset;
    private int mLastEventOffset;
    private MotionEvent mLastMoveEvent;

    public AbsRefreshLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, null, R.attr.absRefreshLayoutStyle);
    }

    public AbsRefreshLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AbsRefreshLayout(Context context) {
        this(context, null);
    }

    public AbsRefreshLayout(View listView) {
        this(listView.getContext());
        this.mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mNestedScrollingChildHelper = new NestedScrollingChildHelper((View)this);
        this.setNestedScrollingEnabled(true);
        this.mTargetView = listView;
        ViewGroup group = (ViewGroup)this.mTargetView.getParent();
        if (group != null) {
            ViewGroup.LayoutParams params = this.mTargetView.getLayoutParams();
            int index = group.indexOfChild(listView);
            group.removeView(listView);
            group.addView((View)this, index, params);
        }
        this.mTargetView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        super.addView(this.mTargetView);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mNestedScrollingChildHelper = new NestedScrollingChildHelper((View)this);
        this.setNestedScrollingEnabled(true);
        this.mScroller = new Scroller(context, (Interpolator)new DecelerateInterpolator());
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AbsRefreshLayout, defStyleAttr, 0);
        int N = a.getIndexCount();
        int resFooter = R.layout.layout_loadmore;
        for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 != R.styleable.AbsRefreshLayout_footerNestLayout) continue;
            resFooter = a.getInt(attr2, resFooter);
            break;
        }
        a.recycle();
        this.setFooterView(AbsRefreshLayout.inflate((Context)context, (int)resFooter, null));
    }

    public void requestDisallowInterceptTouchEvent(boolean b) {
        if (!(Build.VERSION.SDK_INT < 21 && this.mTargetView instanceof AbsListView || this.mTargetView != null && !ViewCompat.isNestedScrollingEnabled((View)this.mTargetView))) {
            super.requestDisallowInterceptTouchEvent(b);
        }
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return this.isEnabled() && (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int axes) {
        this.mNestedScrollInProgress = true;
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(child, target, axes);
        this.startNestedScroll(axes & 2);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int[] parentConsumed;
        int oldScrollY = this.mTotalOffset;
        if (dy * oldScrollY > 0) {
            int moveY;
            consumed[1] = moveY = Math.abs(dy) > Math.abs(oldScrollY) ? oldScrollY : dy;
            if (this.offsetLayout(-moveY)) {
                this.mTotalOffset -= moveY;
            }
        }
        if (this.dispatchNestedPreScroll(dx - consumed[0], dy - consumed[1], parentConsumed = this.mParentScrollConsumed, null)) {
            consumed[0] = consumed[0] + parentConsumed[0];
            consumed[1] = consumed[1] + parentConsumed[1];
        }
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    public void onStopNestedScroll(View target) {
        this.mNestedScrollingParentHelper.onStopNestedScroll(target);
        this.mNestedScrollInProgress = false;
        this.touchUp(null);
        this.stopNestedScroll();
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, this.mParentOffsetInWindow);
        int dy = dyUnconsumed + this.mParentOffsetInWindow[1];
        if ((dy /= 2) < 0 && this.mEnableFresh) {
            if (this.offsetLayout(-dy)) {
                this.mTotalOffset -= dy;
            }
        } else if (dy > 0 && this.mEnablePullLoad && this.offsetLayout(-dy)) {
            this.mTotalOffset -= dy;
        }
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mNestedScrollingChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mNestedScrollingChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mNestedScrollingChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mNestedScrollingChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mNestedScrollingChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        this.resetView();
        return this.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return this.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mNestedScrollingChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    protected void setHeaderView(View headerView) {
        this.mHeaderView = headerView;
        this.addView(this.mHeaderView);
    }

    protected void setFooterView(View footerView) {
        this.mFooterView = footerView;
        this.addView(this.mFooterView);
    }

    public void setEmptyView(View view) {
        if (this.mEmptyView == view) {
            return;
        }
        if (this.mEmptyView != null) {
            this.removeViewInLayout(this.mEmptyView);
        }
        this.mEmptyView = view;
        if (this.mEmptyView.getParent() != null) {
            ((ViewGroup)this.mEmptyView.getParent()).removeView(this.mEmptyView);
        }
        this.mEmptyView.setVisibility(8);
        if (this.mTargetView != null) {
            this.addView(this.mEmptyView, 1, new ViewGroup.LayoutParams(-1, -1));
        } else {
            this.addView(this.mEmptyView, new ViewGroup.LayoutParams(-1, -1));
        }
    }

    public View getEmptyView() {
        return this.mEmptyView;
    }

    public void setContentView(View view) {
        this.mTargetView = view;
        super.addView(view);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        if (child != this.mHeaderView && child != this.mFooterView && this.mTargetView == null) {
            this.mTargetView = child;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View child;
        int i;
        int count = this.getChildCount();
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth());
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight());
            childState = ViewCompat.combineMeasuredStates((int)childState, (int)ViewCompat.getMeasuredState((View)child));
        }
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(ViewCompat.resolveSizeAndState((int)maxWidth, (int)widthMeasureSpec, (int)childState), ViewCompat.resolveSizeAndState((int)maxHeight, (int)heightMeasureSpec, (int)(childState << 16)));
        if (count > 1) {
            for (i = 0; i < count; ++i) {
                int childHeightMeasureSpec;
                int childWidthMeasureSpec;
                child = this.getChildAt(i);
                ViewGroup.LayoutParams lp = child.getLayoutParams();
                if (lp.width == -1) {
                    int width = Math.max(0, this.getMeasuredWidth());
                    childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
                } else {
                    childWidthMeasureSpec = AbsRefreshLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)lp.width);
                }
                if (lp.height == -1) {
                    int height = Math.max(0, this.getMeasuredHeight());
                    childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
                } else {
                    childHeightMeasureSpec = AbsRefreshLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)lp.height);
                }
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mEmptyView != null && this.mEmptyView.getVisibility() == 0) {
            this.mEmptyView.layout(0, 0, this.mEmptyView.getMeasuredWidth(), this.mEmptyView.getMeasuredHeight());
        }
        if (this.mTargetView != null) {
            this.mTargetView.layout(0, 0, this.mTargetView.getMeasuredWidth(), this.mTargetView.getMeasuredHeight());
        }
        if (this.mHeaderView != null) {
            this.mHeaderView.layout(0, 0 - this.mHeaderView.getMeasuredHeight(), this.mHeaderView.getMeasuredWidth(), 0);
        }
        if (this.mFooterView != null) {
            this.mFooterView.layout(0, this.getMeasuredHeight(), this.mFooterView.getMeasuredWidth(), this.getMeasuredHeight() + this.mFooterView.getMeasuredHeight());
        }
    }

    public void requestLayout() {
        if (this.mbLayout) {
            return;
        }
        this.mbLayout = true;
        super.requestLayout();
        this.mbLayout = false;
    }

    public void setPullRefreshEnable(boolean enable) {
        this.mEnableFresh = enable;
        if (!this.mEnableFresh) {
            this.resetView();
        } else {
            this.mbRefreshing = false;
        }
    }

    public void setPullLoadEnable(boolean enable) {
        if (this.mEnablePullLoad == enable) {
            return;
        }
        this.mEnablePullLoad = enable;
        if (!this.mEnablePullLoad) {
            this.resetView();
        } else {
            this.mbLoading = false;
        }
    }

    public boolean isRefreshEnable() {
        return this.mEnableFresh;
    }

    public boolean isLoadMoreEnable() {
        return this.mEnablePullLoad;
    }

    public boolean isRefreshing() {
        return this.mbRefreshing;
    }

    protected void setRefreshing(boolean refresh) {
        this.mbRefreshing = refresh;
    }

    protected void setLoading(boolean refresh) {
        this.mbLoading = refresh;
    }

    public boolean isLoadingMore() {
        return this.mbLoading;
    }

    public boolean isLoadAll() {
        return this.mbLoadAll;
    }

    public void showLoading() {
    }

    public void setOnLoadingListener(OnPullListener listener) {
        this.mLoadListener = listener;
    }

    protected boolean offsetLayout(float delY) {
        this.scrollBy(0, (int)(-delY));
        return true;
    }

    public void computeScroll() {
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            int y = this.mScroller.getCurrY();
            int oldY = this.getScrollY();
            this.scrollTo(0, y);
            this.mTotalOffset -= y - oldY;
            ViewCompat.postInvalidateOnAnimation((View)this);
        } else {
            super.computeScroll();
        }
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (t > 0 && !this.isLoadingMore() && this.isLoadMoreEnable() && !this.isLoadAll()) {
            if (t > this.mFooterView.getMeasuredHeight()) {
                ((LoaderDecor)this.mFooterView).setState(1);
            } else {
                ((LoaderDecor)this.mFooterView).setState(0);
            }
        }
    }

    protected void touchUp(MotionEvent event) {
        if (!this.shouldLoadMore()) {
            this.resetView();
        }
    }

    protected boolean shouldLoadMore() {
        if (this.mFooterView.getMeasuredHeight() <= this.getScrollY() && !this.isLoadAll()) {
            ((LoaderDecor)this.mFooterView).setState(2);
            this.animation2Footer();
            return true;
        }
        return false;
    }

    protected void invokeRefresh() {
        if (this.mLoadListener != null && !this.mbRefreshingInvoked) {
            this.mbRefreshingInvoked = true;
            this.mLoadListener.onRefresh(this);
        } else if (!this.mbRefreshingInvoked) {
            this.mbRefreshingInvoked = true;
        }
    }

    protected void invokeLoadMore() {
        if (this.mLoadListener != null && !this.mbLoadingInvoked) {
            this.mbLoadingInvoked = true;
            this.mLoadListener.onLoading(this);
        } else {
            this.mbLoadingInvoked = true;
        }
    }

    protected int getOffsetY() {
        return this.mTotalOffset;
    }

    protected void resetView() {
        this.animation2Y(0);
    }

    protected int animation2Y(int y) {
        this.mScroller.abortAnimation();
        int duration = Math.abs(y - this.getScrollY());
        duration = Math.max(200, duration);
        this.mScroller.startScroll(0, this.getScrollY(), 0, y - this.getScrollY(), duration);
        ViewCompat.postInvalidateOnAnimation((View)this);
        return duration;
    }

    protected void animation2Footer() {
        this.setLoading(true);
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                AbsRefreshLayout.this.invokeLoadMore();
            }
        }, this.animation2Y(this.mFooterView.getMeasuredHeight()));
    }

    public void onLoadFinished() {
        this.setRefreshing(false);
        this.setLoading(false);
        this.mbRefreshingInvoked = false;
        this.mbLoadingInvoked = false;
        this.mbLoadAll = false;
        if (this.mFooterView != null) {
            ((LoaderDecor)this.mFooterView).setState(0);
        }
        this.resetView();
    }

    public void onLoadAll() {
        this.mbRefreshingInvoked = false;
        this.mbLoadingInvoked = false;
        this.setRefreshing(false);
        this.setLoading(false);
        this.mbLoadAll = true;
        if (this.mFooterView != null) {
            ((LoaderDecor)this.mFooterView).setState(4);
        }
        this.resetView();
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (!this.isEnabled() || this.mNestedScrollInProgress) {
            return false;
        }
        if (!this.mEnableFresh && !this.mEnablePullLoad) {
            return false;
        }
        int action = MotionEventCompat.getActionMasked((MotionEvent)event);
        switch (action) {
            case 0: {
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)0);
                this.mFirstTouchDownPointY = this.getMotionEventY(event, this.mActivePointerId);
                this.mLastEventOffset = (int)this.mFirstTouchDownPointY;
                break;
            }
            case 2: {
                float yDiff;
                if (this.mActivePointerId == -1) {
                    return false;
                }
                float currentY = this.getMotionEventY(event, this.mActivePointerId);
                if (currentY == -1.0f) {
                    return false;
                }
                if (this.mFirstTouchDownPointY == -1.0f) {
                    this.mFirstTouchDownPointY = currentY;
                }
                if (this.mLastEventOffset == -1) {
                    this.mLastEventOffset = (int)currentY;
                }
                if (!(Math.abs(yDiff = currentY - this.mFirstTouchDownPointY) > (float)ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop())) break;
                return this.shouldIntercept((int)yDiff);
            }
            case 1: 
            case 3: {
                this.mActivePointerId = -1;
            }
        }
        return false;
    }

    private boolean shouldIntercept(int dis) {
        if (dis == 0) {
            return false;
        }
        if (!this.mEnableFresh && !this.mEnablePullLoad) {
            return false;
        }
        return !this.canScrollVertically(dis = -dis) && (dis < 0 ? this.mEnableFresh : this.mEnablePullLoad);
    }

    public boolean canScrollVertically(int direction) {
        if (Build.VERSION.SDK_INT < 14) {
            if (this.mTargetView instanceof AdapterView) {
                return this.canListScroll(direction);
            }
            return direction < 0 ? this.mTargetView.getScrollY() > 0 : this.mTargetView.getScrollY() < this.mTargetView.getMeasuredHeight();
        }
        return ViewCompat.canScrollVertically((View)this.mTargetView, (int)direction);
    }

    private boolean canListScroll(int direction) {
        View firstView;
        View lastView;
        AdapterView absListView = (AdapterView)this.mTargetView;
        int itemCount = absListView.getCount();
        int childCount = absListView.getChildCount();
        int firstPosition = absListView.getFirstVisiblePosition();
        int lastPosition = firstPosition + childCount;
        if (itemCount == 0) {
            return false;
        }
        return !(direction > 0 ? lastPosition >= itemCount && (lastView = absListView.getChildAt(childCount - 1)) != null && lastView.getBottom() >= this.mTargetView.getHeight() : direction < 0 && firstPosition <= 0 && (firstView = absListView.getChildAt(0)) != null && firstView.getTop() >= 0);
    }

    private float getMotionEventY(@NonNull MotionEvent ev, int activePointerId) {
        int index = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)activePointerId);
        if (index < 0) {
            return -1.0f;
        }
        return MotionEventCompat.getY((MotionEvent)ev, (int)index);
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (!this.isEnabled() || this.mNestedScrollInProgress) {
            return false;
        }
        int action = MotionEventCompat.getActionMasked((MotionEvent)event);
        int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)event, (int)this.mActivePointerId);
        switch (action) {
            case 2: {
                this.releaseEvent();
                this.mLastMoveEvent = MotionEvent.obtain((MotionEvent)event);
                return pointerIndex >= 0 && this.onMoveTouchEvent(event, pointerIndex);
            }
            case 1: 
            case 3: {
                if (this.mActivePointerId == -1) {
                    return false;
                }
                this.touchUp(event);
                this.mLastEventOffset = -1;
                this.mFirstTouchDownPointY = -1.0f;
                this.mActivePointerId = -1;
                return false;
            }
        }
        return true;
    }

    private void releaseEvent() {
        if (this.mLastMoveEvent != null) {
            this.mLastMoveEvent.recycle();
            this.mLastMoveEvent = null;
        }
    }

    private boolean onMoveTouchEvent(@NonNull MotionEvent event, int pointerIndex) {
        if (this.IsBeingDropped()) {
            return false;
        }
        float y = MotionEventCompat.getY((MotionEvent)event, (int)pointerIndex);
        float diffY = y - (float)this.mLastEventOffset;
        if ((diffY /= 2.0f) >= 0.0f && !this.isRefreshEnable() || diffY < 0.0f && !this.isLoadMoreEnable()) {
            return false;
        }
        this.mLastEventOffset = (int)y;
        if (!this.shouldIntercept((int)((float)this.mTotalOffset + diffY))) {
            this.sendUpEvent();
            this.sendDownEvent();
            return false;
        }
        if (this.offsetLayout(diffY)) {
            this.mTotalOffset = (int)((float)this.mTotalOffset + diffY);
            return true;
        }
        return false;
    }

    private void sendDownEvent() {
        MotionEvent last = this.mLastMoveEvent;
        MotionEvent e = MotionEvent.obtain((long)last.getDownTime(), (long)last.getEventTime(), (int)0, (float)last.getX(), (float)last.getY(), (int)last.getMetaState());
        this.dispatchTouchEvent(e);
    }

    private void sendUpEvent() {
        MotionEvent last = this.mLastMoveEvent;
        MotionEvent e = MotionEvent.obtain((long)last.getDownTime(), (long)last.getEventTime(), (int)1, (float)last.getX(), (float)last.getY(), (int)last.getMetaState());
        this.dispatchTouchEvent(e);
    }

    protected boolean IsBeingDropped() {
        return false;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.LayoutParams(-1, -2);
    }

    public static interface LoaderDecor {
        public static final int STATE_NORMAL = 0;
        public static final int STATE_READY = 1;
        public static final int STATE_REFRESHING = 2;
        public static final int STATE_ALL = 4;
        public static final int STATE_SUCCESS = 5;

        public void scrollRate(int var1);

        public void setState(int var1);
    }
}

