/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker.command;

import cloud.localstack.docker.PortMapping;
import cloud.localstack.docker.command.Command;
import cloud.localstack.docker.command.RegexStream;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PortCommand
extends Command {
    private static final Pattern PORT_MAPPING_PATTERN = Pattern.compile("(\\d+)/tcp -> ((\\d)(\\.(\\d)){3}):(\\d+)");
    private static final int INTERNAL_PORT_GROUP = 1;
    private static final int EXTERNAL_PORT_GROUP = 6;
    private static final int IP_GROUP = 2;
    private final String containerId;
    private Function<MatchResult, PortMapping> matchToPortMapping = m -> new PortMapping(m.group(2), m.group(6), m.group(1));

    public PortCommand(String containerId) {
        this.containerId = containerId;
    }

    public List<PortMapping> execute() {
        String output = this.dockerExe.execute(Arrays.asList("port", this.containerId));
        return new RegexStream(PORT_MAPPING_PATTERN.matcher(output)).stream().map(this.matchToPortMapping).collect(Collectors.toList());
    }
}

