/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.extclassgenerator.validation;

import ch.rasc.extclassgenerator.validation.AbstractValidation;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RangeValidation
extends AbstractValidation {
    private final BigDecimal min;
    private final BigDecimal max;

    public RangeValidation(String field, Long min, Long max) {
        this(field, min != null ? new BigDecimal(min) : null, max != null ? new BigDecimal(max) : null);
    }

    public RangeValidation(String field, BigDecimal min, BigDecimal max) {
        super("range", field);
        if (min == null && max == null) {
            throw new IllegalArgumentException("At least min or max must be set");
        }
        this.min = min;
        this.max = max;
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public BigDecimal getMax() {
        return this.max;
    }
}

