/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.controller;

import ch.ralscha.extdirectspring.controller.BatchedMethodsExecutionPolicy;
import ch.ralscha.extdirectspring.controller.Configuration;
import ch.ralscha.extdirectspring.controller.DefaultRouterExceptionHandler;
import ch.ralscha.extdirectspring.controller.RouterExceptionHandler;
import ch.ralscha.extdirectspring.util.JsonHandler;
import ch.ralscha.extdirectspring.util.ParametersResolver;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.support.WebArgumentResolver;

@Service
public class ConfigurationService
implements InitializingBean,
DisposableBean {
    @Autowired
    private ApplicationContext context;
    @Autowired(required=false)
    private Configuration configuration;
    @Autowired(required=false)
    private JsonHandler jsonHandler;
    @Autowired(required=false)
    private RouterExceptionHandler routerExceptionHandler;
    private ParametersResolver parametersResolver;

    public void afterPropertiesSet() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
        }
        if (this.configuration.getJsonHandler() != null) {
            this.jsonHandler = this.configuration.getJsonHandler();
        }
        if (this.jsonHandler == null) {
            this.jsonHandler = new JsonHandler();
        }
        if (this.routerExceptionHandler == null) {
            this.routerExceptionHandler = new DefaultRouterExceptionHandler(this);
        }
        if (this.configuration.getBatchedMethodsExecutionPolicy() == BatchedMethodsExecutionPolicy.CONCURRENT && this.configuration.getBatchedMethodsExecutorService() == null) {
            this.configuration.setBatchedMethodsExecutorService(Executors.newFixedThreadPool(5));
        }
        if (this.configuration.getConversionService() == null) {
            Map conversionServices = this.context.getBeansOfType(ConversionService.class);
            if (conversionServices.isEmpty()) {
                this.configuration.setConversionService((ConversionService)new DefaultFormattingConversionService());
            } else if (conversionServices.size() == 1) {
                this.configuration.setConversionService((ConversionService)conversionServices.values().iterator().next());
            } else if (conversionServices.containsKey("mvcConversionService")) {
                this.configuration.setConversionService((ConversionService)conversionServices.get("mvcConversionService"));
            } else {
                for (ConversionService conversionService : conversionServices.values()) {
                    if (!(conversionService instanceof FormattingConversionService)) continue;
                    this.configuration.setConversionService(conversionService);
                    break;
                }
                if (this.configuration.getConversionService() == null) {
                    this.configuration.setConversionService((ConversionService)conversionServices.values().iterator().next());
                }
            }
        }
        Collection<WebArgumentResolver> webResolvers = this.context.getBeansOfType(WebArgumentResolver.class).values();
        this.parametersResolver = new ParametersResolver(this.configuration.getConversionService(), this.jsonHandler, webResolvers);
    }

    public void destroy() throws Exception {
        if (this.configuration.getBatchedMethodsExecutorService() != null) {
            this.configuration.getBatchedMethodsExecutorService().shutdown();
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public JsonHandler getJsonHandler() {
        return this.jsonHandler;
    }

    public ApplicationContext getApplicationContext() {
        return this.context;
    }

    public ParametersResolver getParametersResolver() {
        return this.parametersResolver;
    }

    public RouterExceptionHandler getRouterExceptionHandler() {
        return this.routerExceptionHandler;
    }
}

