/*
 * Decompiled with CFR 0.152.
 */
package step.core.collections;

import java.util.List;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import step.core.accessors.DefaultJacksonMapperProvider;
import step.core.collections.Collection;
import step.core.collections.CollectionFactory;
import step.core.collections.Document;
import step.core.collections.Filter;
import step.core.collections.Filters;
import step.core.collections.SearchOrder;
import step.core.collections.serialization.DottedKeyMap;
import step.core.entities.Bean;
import step.core.entities.SimpleBean;

public abstract class AbstractCollectionTest {
    private static final String COLLECTION = "beans";
    private static final String NEW_VALUE = "newValue";
    private static final String VALUE1 = "Test1";
    private static final String VALUE2 = "Test2";
    private static final String VALUE3 = "Test3";
    private static final String PROPERTY1 = "property1";
    protected final CollectionFactory collectionFactory;

    public AbstractCollectionTest(CollectionFactory collectionFactory) {
        this.collectionFactory = collectionFactory;
    }

    @Test
    public void testCounts() throws Exception {
        Collection beanCollection = this.collectionFactory.getCollection(COLLECTION, Bean.class);
        beanCollection.remove((Filter)Filters.empty());
        long count = beanCollection.count((Filter)Filters.empty(), Integer.valueOf(10));
        Assert.assertEquals((long)0L, (long)count);
        count = beanCollection.count((Filter)Filters.regex((String)"dummy", (String)"dummy", (boolean)false), Integer.valueOf(10));
        Assert.assertEquals((long)0L, (long)count);
        count = beanCollection.estimatedCount();
        Assert.assertEquals((long)0L, (long)count);
        Bean bean1 = new Bean(VALUE1);
        beanCollection.save((Object)bean1);
        count = beanCollection.estimatedCount();
        Assert.assertEquals((long)1L, (long)count);
        count = beanCollection.count((Filter)Filters.empty(), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)count);
        Bean bean2 = new Bean(VALUE1);
        beanCollection.save((Object)bean2);
        count = beanCollection.count((Filter)Filters.empty(), Integer.valueOf(10));
        Assert.assertEquals((long)2L, (long)count);
        count = beanCollection.count((Filter)Filters.empty(), Integer.valueOf(1));
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testGetById() throws Exception {
        Collection beanCollection = this.collectionFactory.getCollection(COLLECTION, Bean.class);
        beanCollection.remove((Filter)Filters.empty());
        Bean bean1 = new Bean(VALUE1);
        SimpleBean simpleBean = new SimpleBean();
        simpleBean.setId("testId");
        bean1.setSimpleBean(simpleBean);
        beanCollection.save((Object)bean1);
        Bean actualBean = (Bean)beanCollection.find((Filter)Filters.id((ObjectId)bean1.getId()), null, null, null, 0).findFirst().get();
        Assert.assertEquals((Object)bean1, (Object)actualBean);
        actualBean = (Bean)beanCollection.find((Filter)Filters.id((String)bean1.getId().toString()), null, null, null, 0).findFirst().get();
        Assert.assertEquals((Object)bean1, (Object)actualBean);
        actualBean = (Bean)beanCollection.find((Filter)Filters.equals((String)"id", (ObjectId)bean1.getId()), null, null, null, 0).findFirst().get();
        Assert.assertEquals((Object)bean1, (Object)actualBean);
        actualBean = (Bean)beanCollection.find((Filter)Filters.equals((String)"id", (String)bean1.getId().toString()), null, null, null, 0).findFirst().get();
        Assert.assertEquals((Object)bean1, (Object)actualBean);
        actualBean = (Bean)beanCollection.find((Filter)Filters.equals((String)"simpleBean.id", (String)"testId"), null, null, null, 0).findFirst().get();
        Assert.assertEquals((Object)bean1, (Object)actualBean);
        Collection documentCollection = this.collectionFactory.getCollection(COLLECTION, Document.class);
        Document actualDocument = (Document)documentCollection.find((Filter)Filters.id((ObjectId)bean1.getId()), null, null, null, 0).findFirst().get();
        Assert.assertEquals((Object)bean1.getId(), (Object)actualDocument.getId());
        actualDocument = (Document)documentCollection.find((Filter)Filters.id((String)bean1.getId().toString()), null, null, null, 0).findFirst().get();
        Assert.assertEquals((Object)bean1.getId(), (Object)actualDocument.getId());
    }

    @Test
    public void test() throws Exception {
        Collection beanCollection = this.collectionFactory.getCollection(COLLECTION, Bean.class);
        beanCollection.remove((Filter)Filters.empty());
        Bean bean1 = new Bean(VALUE1);
        beanCollection.save((Object)bean1);
        Collection mapCollection = this.collectionFactory.getCollection(COLLECTION, Document.class);
        Document document = (Document)mapCollection.find((Filter)Filters.equals((String)PROPERTY1, (String)VALUE1), null, null, null, 0).findFirst().get();
        Object id = document.get((Object)"id");
        Assert.assertTrue((boolean)(id instanceof String));
        Assert.assertEquals((Object)bean1.getId(), (Object)document.getId());
        Assert.assertEquals((Object)VALUE1, (Object)document.get((Object)PROPERTY1));
        Bean bean = (Bean)DefaultJacksonMapperProvider.getObjectMapper().convertValue((Object)document, Bean.class);
        Assert.assertEquals((Object)bean1, (Object)bean);
        document.put(PROPERTY1, (Object)NEW_VALUE);
        mapCollection.save((Object)document);
        Bean actualBean = (Bean)beanCollection.find((Filter)Filters.equals((String)"id", (ObjectId)new ObjectId(document.get((Object)"id").toString())), null, null, null, 0).findFirst().get();
        Assert.assertEquals((Object)NEW_VALUE, (Object)actualBean.getProperty1());
    }

    @Test
    public void testSave() throws Exception {
        Collection beanCollection = this.collectionFactory.getCollection(COLLECTION, Bean.class);
        beanCollection.remove((Filter)Filters.empty());
        Bean bean1 = new Bean(VALUE1);
        bean1.setId(null);
        beanCollection.save((Object)bean1);
        Bean bean1AfterSave = (Bean)beanCollection.save((Object)bean1);
        Assert.assertNotNull((Object)bean1AfterSave.getId());
        Collection documentCollection = this.collectionFactory.getCollection(COLLECTION, Document.class);
        documentCollection.remove((Filter)Filters.empty());
        Document document = new Document();
        document.put("_class", (Object)Bean.class.getName());
        document = (Document)documentCollection.save((Object)document);
        Assert.assertNotNull((Object)document.get((Object)"id"));
    }

    @Test
    public void testFind() throws Exception {
        Collection beanCollection = this.collectionFactory.getCollection(COLLECTION, Bean.class);
        beanCollection.remove((Filter)Filters.empty());
        Bean bean1 = new Bean(VALUE1);
        Bean bean2 = new Bean(VALUE2);
        Bean bean3 = new Bean(VALUE3);
        beanCollection.save(List.of(bean1, bean3, bean2));
        List result = beanCollection.find((Filter)Filters.empty(), new SearchOrder(PROPERTY1, 1), null, null, 0).collect(Collectors.toList());
        Assert.assertEquals(List.of(bean1, bean2, bean3), result);
        result = beanCollection.find((Filter)Filters.empty(), new SearchOrder("id", 1), null, null, 0).collect(Collectors.toList());
        Assert.assertEquals(List.of(bean1, bean2, bean3), result);
        result = beanCollection.find((Filter)Filters.empty(), new SearchOrder(PROPERTY1, -1), null, null, 0).collect(Collectors.toList());
        Assert.assertEquals(List.of(bean3, bean2, bean1), result);
        result = beanCollection.find((Filter)Filters.empty(), new SearchOrder(PROPERTY1, 1), Integer.valueOf(1), Integer.valueOf(2), 0).collect(Collectors.toList());
        Assert.assertEquals(List.of(bean2, bean3), result);
    }

    @Test
    public void testFindFilters() {
        Collection collection = this.collectionFactory.getCollection(COLLECTION, Bean.class);
        collection.remove((Filter)Filters.empty());
        Bean bean = new Bean();
        bean.setProperty1("My property 1");
        bean.setLongProperty(Long.valueOf(11L));
        bean.setBooleanProperty(false);
        bean.addAttribute("MyAtt1", "My value 1");
        collection.save((Object)bean);
        Bean bean2 = new Bean();
        bean2.setProperty1("My property 2");
        bean2.setLongProperty(Long.valueOf(21L));
        bean2.setBooleanProperty(false);
        bean2.addAttribute("MyAtt1", "My value 2");
        collection.save((Object)bean2);
        List result = collection.find((Filter)Filters.regex((String)PROPERTY1, (String)"My", (boolean)true), new SearchOrder("MyAtt1", 1), null, null, 0).collect(Collectors.toList());
        Assert.assertEquals((Object)bean.getId(), (Object)((Bean)result.get(0)).getId());
        result = collection.find((Filter)Filters.regex((String)"attributes.MyAtt1", (String)"My", (boolean)true), new SearchOrder("MyAtt1", 1), null, null, 0).collect(Collectors.toList());
        Assert.assertEquals((Object)bean.getId(), (Object)((Bean)result.get(0)).getId());
        result = collection.find((Filter)Filters.equals((String)PROPERTY1, (String)"My property 1"), new SearchOrder("MyAtt1", 1), null, null, 0).collect(Collectors.toList());
        Assert.assertEquals((Object)bean.getId(), (Object)((Bean)result.get(0)).getId());
        result = collection.find((Filter)Filters.equals((String)"attributes.MyAtt1", (String)"My value 1"), new SearchOrder("MyAtt1", 1), null, null, 0).collect(Collectors.toList());
        Assert.assertEquals((Object)bean.getId(), (Object)((Bean)result.get(0)).getId());
        result = collection.find((Filter)Filters.equals((String)"booleanProperty", (boolean)false), new SearchOrder("MyAtt1", 1), null, null, 0).collect(Collectors.toList());
        Assert.assertEquals((Object)bean.getId(), (Object)((Bean)result.get(0)).getId());
        result = collection.find((Filter)Filters.equals((String)"longProperty", (long)11L), new SearchOrder("MyAtt1", 1), null, null, 0).collect(Collectors.toList());
        Assert.assertEquals((Object)bean.getId(), (Object)((Bean)result.get(0)).getId());
        result = collection.find((Filter)Filters.equals((String)"missingField", (String)null), new SearchOrder("MyAtt1", 1), null, null, 0).collect(Collectors.toList());
        Assert.assertEquals((Object)bean.getId(), (Object)((Bean)result.get(0)).getId());
        result = collection.find((Filter)Filters.and(List.of(Filters.gte((String)"longProperty", (long)11L), Filters.lt((String)"longProperty", (long)21L))), new SearchOrder("MyAtt1", 1), null, null, 0).collect(Collectors.toList());
        Assert.assertEquals((Object)bean.getId(), (Object)((Bean)result.get(0)).getId());
        Assert.assertEquals((long)1L, (long)result.size());
        result = collection.find((Filter)Filters.and(List.of(Filters.gt((String)"longProperty", (long)11L), Filters.lte((String)"longProperty", (long)21L))), new SearchOrder("MyAtt1", 1), null, null, 0).collect(Collectors.toList());
        Assert.assertEquals((Object)bean2.getId(), (Object)((Bean)result.get(0)).getId());
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testFindBySpecialFilters() throws Exception {
        Collection beanCollection = this.collectionFactory.getCollection(COLLECTION, Bean.class);
        beanCollection.remove((Filter)Filters.empty());
        Bean bean1 = new Bean(VALUE1);
        bean1.setNested(new Bean());
        beanCollection.save((Object)bean1);
        Bean actualBean = (Bean)beanCollection.find((Filter)Filters.regex((String)"_class", (String)"Bean", (boolean)true), null, null, null, 0).findFirst().get();
        Assert.assertEquals((Object)bean1, (Object)actualBean);
        beanCollection.find((Filter)Filters.regex((String)"nested._class", (String)"Bean", (boolean)true), null, null, null, 0).findFirst().get();
        Assert.assertEquals((Object)bean1, (Object)actualBean);
        actualBean = (Bean)beanCollection.find((Filter)Filters.equals((String)"id", (ObjectId)bean1.getId()), null, null, null, 0).findFirst().get();
        Assert.assertEquals((Object)bean1, (Object)actualBean);
    }

    @Test
    public void testRemove() throws Exception {
        Collection beanCollection = this.collectionFactory.getCollection(COLLECTION, Bean.class);
        beanCollection.remove((Filter)Filters.empty());
        beanCollection.save((Object)new Bean(VALUE1));
        beanCollection.remove((Filter)Filters.equals((String)PROPERTY1, (String)VALUE1));
        Assert.assertNull(beanCollection.find((Filter)Filters.equals((String)PROPERTY1, (String)VALUE1), new SearchOrder("property", 1), null, null, 0).findFirst().orElse(null));
    }

    @Test
    public void testSerializers() throws Exception {
        Collection beanCollection = this.collectionFactory.getCollection(COLLECTION, Bean.class);
        beanCollection.remove((Filter)Filters.empty());
        Bean bean1 = new Bean(VALUE1);
        JsonObject json = Json.createObjectBuilder().add("test", "value").build();
        bean1.setJsonObject(json);
        JSONObject jsonOrgObject = new JSONObject();
        jsonOrgObject.put("key", (Object)"value");
        bean1.setJsonOrgObject(jsonOrgObject);
        DottedKeyMap map = new DottedKeyMap();
        map.put((Object)"key.with.dots", (Object)"value");
        bean1.setMap(map);
        beanCollection.save((Object)bean1);
        Bean actualBean = (Bean)beanCollection.find((Filter)Filters.id((ObjectId)bean1.getId()), null, null, null, 0).findFirst().get();
        Assert.assertEquals((Object)json, (Object)actualBean.getJsonObject());
        Assert.assertEquals((Object)"value", (Object)actualBean.getJsonOrgObject().get("key"));
        Assert.assertEquals((Object)"value", (Object)actualBean.getMap().get((Object)"key.with.dots"));
    }
}

