/*
 * Decompiled with CFR 0.152.
 */
package step.core.collections.inmemory;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.bson.types.ObjectId;
import step.core.accessors.DefaultJacksonMapperProvider;
import step.core.collections.Collection;
import step.core.collections.Document;
import step.core.collections.Filter;
import step.core.collections.PojoFilter;
import step.core.collections.PojoFilters;
import step.core.collections.PojoUtils;
import step.core.collections.SearchOrder;
import step.core.collections.filesystem.AbstractCollection;

public class InMemoryCollection<T>
extends AbstractCollection<T>
implements Collection<T> {
    private final Class<T> entityClass;
    private final Map<ObjectId, T> entities;
    private final ObjectMapper mapper = DefaultJacksonMapperProvider.getObjectMapper();

    public InMemoryCollection() {
        this.entityClass = null;
        this.entities = new ConcurrentHashMap<ObjectId, T>();
    }

    public InMemoryCollection(Class<T> entityClass, Map<ObjectId, T> entities) {
        this.entityClass = entityClass;
        this.entities = entities;
    }

    @Override
    public List<String> distinct(String columnName, Filter filter) {
        return null;
    }

    @Override
    public long count(Filter filter, Integer limit) {
        Stream<T> stream = this.find(filter, null, null, null, 0);
        if (limit != null) {
            stream = stream.limit(limit.intValue());
        }
        return stream.count();
    }

    @Override
    public long estimatedCount() {
        return this.entities.size();
    }

    @Override
    public Stream<T> find(Filter filter, SearchOrder order, Integer skip, Integer limit, int maxTime) {
        Stream<Object> stream = this.filteredStream(filter);
        if (order != null) {
            Comparator<Object> comparing = PojoUtils.comparator(order.getAttributeName());
            if (order.getOrder() < 0) {
                comparing = comparing.reversed();
            }
            stream = stream.sorted(comparing);
        }
        if (skip != null) {
            stream = stream.skip(skip.intValue());
        }
        if (limit != null) {
            stream = stream.limit(limit.intValue());
        }
        return stream.map(e -> {
            if (this.entityClass == Document.class && !(e instanceof Document)) {
                return this.mapper.convertValue(e, Document.class);
            }
            if (e instanceof Document && this.entityClass != Document.class) {
                return this.mapper.convertValue(e, this.entityClass);
            }
            return e;
        });
    }

    @Override
    public Stream<T> findReduced(Filter filter, SearchOrder order, Integer skip, Integer limit, int maxTime, List<String> reduceFields) {
        return this.find(filter, order, skip, limit, maxTime);
    }

    private Stream<T> filteredStream(Filter filter) {
        Object pojoFilter = new PojoFilters.PojoFilterFactory().buildFilter(filter);
        return this.entityStream().filter(((PojoFilter)pojoFilter)::test).sorted(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return InMemoryCollection.this.getId(o1).compareTo(InMemoryCollection.this.getId(o2));
            }
        });
    }

    private Stream<T> entityStream() {
        return this.entities.values().stream();
    }

    @Override
    public void remove(Filter filter) {
        this.filteredStream(filter).forEach(f -> this.entities.remove(this.getId(f)));
    }

    @Override
    public T save(T entity) {
        if (this.getId(entity) == null) {
            this.setId(entity, new ObjectId());
        }
        this.entities.put(this.getId(entity), entity);
        return entity;
    }

    @Override
    public void save(Iterable<T> entities) {
        if (entities != null) {
            entities.forEach(e -> this.save(e));
        }
    }

    @Override
    public void createOrUpdateIndex(String field) {
    }

    @Override
    public void createOrUpdateCompoundIndex(String ... fields) {
    }

    @Override
    public void rename(String newName) {
    }

    @Override
    public void drop() {
    }
}

