/*
 * Decompiled with CFR 0.152.
 */
package step.core.collections.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import step.core.collections.Collection;
import step.core.collections.CollectionFactory;
import step.core.collections.filesystem.FilesystemCollection;

public class FilesystemCollectionFactory
implements CollectionFactory {
    public static final String FILESYSTEM_PATH = "path";
    private final File workspace;

    public FilesystemCollectionFactory(Properties properties) {
        this.workspace = new File(properties.getProperty(FILESYSTEM_PATH, "db"));
    }

    public FilesystemCollectionFactory(File workspace) {
        this.workspace = workspace;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public <T> Collection<T> getCollection(String name, Class<T> entityClass) {
        return new FilesystemCollection<T>(new File(this.workspace.getAbsolutePath() + "/" + name), entityClass);
    }
}

