/*
 * Decompiled with CFR 0.152.
 */
package step.core.collections.filesystem;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.types.ObjectId;
import step.core.accessors.DefaultJacksonMapperProvider;
import step.core.collections.Collection;
import step.core.collections.Filter;
import step.core.collections.PojoFilter;
import step.core.collections.PojoFilters;
import step.core.collections.PojoUtils;
import step.core.collections.SearchOrder;
import step.core.collections.filesystem.AbstractCollection;
import step.core.collections.filesystem.FilesystemCollectionException;

public class FilesystemCollection<T>
extends AbstractCollection<T>
implements Collection<T> {
    private static final String FILE_EXTENSION = ".entity";
    private final ObjectMapper mapper;
    private final File repository;
    private final Class<T> entityClass;

    public FilesystemCollection(File repository, Class<T> entityClass) {
        this.repository = repository;
        this.entityClass = entityClass;
        YAMLFactory factory = new YAMLFactory();
        factory.disable(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID);
        this.mapper = DefaultJacksonMapperProvider.getObjectMapper((JsonFactory)factory);
        if (!repository.exists()) {
            repository.mkdirs();
        }
    }

    @Override
    public List<String> distinct(String columnName, Filter filter) {
        return null;
    }

    private Stream<FileAndEntity<T>> entityStream() {
        return Arrays.asList(this.repository.listFiles(f -> f.getName().endsWith(FILE_EXTENSION))).stream().map(f -> new FileAndEntity<T>((File)f, this.readFile((File)f)));
    }

    @Override
    public long count(Filter filter, Integer limit) {
        Stream<T> stream = this.find(filter, null, null, null, 0);
        if (limit != null) {
            stream = stream.limit(limit.intValue());
        }
        return stream.count();
    }

    @Override
    public long estimatedCount() {
        return this.repository.list().length;
    }

    @Override
    public Stream<T> find(Filter filter, SearchOrder order, Integer skip, Integer limit, int maxTime) {
        Stream<Object> stream = this.filteredStream(filter).map(FileAndEntity::getEntity).sorted(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return FilesystemCollection.this.getId(o1).compareTo(FilesystemCollection.this.getId(o2));
            }
        });
        if (order != null) {
            Comparator<Object> comparing = PojoUtils.comparator(order.getAttributeName());
            if (order.getOrder() < 0) {
                comparing = comparing.reversed();
            }
            stream = stream.sorted(comparing);
        }
        if (skip != null) {
            stream = stream.skip(skip.intValue());
        }
        if (limit != null) {
            stream = stream.limit(limit.intValue());
        }
        return stream;
    }

    @Override
    public Stream<T> findReduced(Filter filter, SearchOrder order, Integer skip, Integer limit, int maxTime, List<String> reduceFields) {
        return this.find(filter, order, skip, limit, maxTime);
    }

    private Stream<FileAndEntity<T>> filteredStream(Filter filter) {
        Object pojoFilter = new PojoFilters.PojoFilterFactory().buildFilter(filter);
        Iterator it = this.entityStream().iterator();
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(it, 0);
        Stream<FileAndEntity<T>> filter2 = StreamSupport.stream(spliterator, false).filter(arg_0 -> FilesystemCollection.lambda$filteredStream$2((PojoFilter)pojoFilter, arg_0));
        return filter2;
    }

    @Override
    public void remove(Filter filter) {
        this.filteredStream(filter).forEach(f -> f.getFile().delete());
    }

    @Override
    public T save(T entity) {
        if (this.getId(entity) == null) {
            this.setId(entity, new ObjectId());
        }
        File file = this.getFile(entity);
        this.writeEntity(entity, file);
        return entity;
    }

    @Override
    public void save(Iterable<T> entities) {
        if (entities != null) {
            entities.forEach(e -> this.save(e));
        }
    }

    private T readFile(File file) {
        try {
            return (T)this.mapper.readValue(file, this.entityClass);
        }
        catch (IOException e) {
            throw new FilesystemCollectionException(e);
        }
    }

    private void writeEntity(T entity, File file) {
        try {
            this.mapper.writeValue(file, entity);
        }
        catch (IOException e) {
            throw new FilesystemCollectionException(e);
        }
    }

    private File getFile(T entity) {
        ObjectId id = this.getId(entity);
        File file = this.getFileById(id);
        return file;
    }

    private File getFileById(ObjectId id) {
        String filename = id.toString() + FILE_EXTENSION;
        File file = new File(this.repository.getAbsolutePath() + "/" + filename);
        return file;
    }

    @Override
    public void createOrUpdateIndex(String field) {
    }

    @Override
    public void createOrUpdateCompoundIndex(String ... fields) {
    }

    @Override
    public void rename(String newName) {
    }

    @Override
    public void drop() {
    }

    private static /* synthetic */ boolean lambda$filteredStream$2(PojoFilter pojoFilter, FileAndEntity f) {
        return pojoFilter.test(f.entity);
    }

    private static class FileAndEntity<T> {
        private final File file;
        private final T entity;

        public FileAndEntity(File file, T entity) {
            this.file = file;
            this.entity = entity;
        }

        public File getFile() {
            return this.file;
        }

        public T getEntity() {
            return this.entity;
        }
    }
}

