/*
 * Decompiled with CFR 0.152.
 */
package step.core.collections;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import step.core.collections.Filter;
import step.core.collections.Filters;
import step.core.collections.PojoFilter;
import step.core.collections.PojoUtils;

public class PojoFilters {
    private static Object getBeanProperty(Object t, String fieldName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return PojoUtils.getProperty(t, fieldName);
    }

    public static class GtePojoFilter<T>
    implements PojoFilter<T> {
        private final Filters.Gte gteFilter;

        public GtePojoFilter(Filters.Gte gteFilter) {
            this.gteFilter = gteFilter;
        }

        @Override
        public boolean test(T t) {
            try {
                String field = this.gteFilter.getField();
                Object beanProperty = PojoFilters.getBeanProperty(t, field);
                long value = this.gteFilter.getValue();
                if (beanProperty instanceof Number) {
                    Number fieldValue = (Number)beanProperty;
                    return fieldValue.longValue() >= value;
                }
                throw new RuntimeException("Gt,Gte,Lt and Lte filters only support numbers, provided field is not compatible: " + field);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return false;
            }
        }
    }

    public static class GtPojoFilter<T>
    implements PojoFilter<T> {
        private final Filters.Gt gtFilter;

        public GtPojoFilter(Filters.Gt gtFilter) {
            this.gtFilter = gtFilter;
        }

        @Override
        public boolean test(T t) {
            try {
                String field = this.gtFilter.getField();
                Object beanProperty = PojoFilters.getBeanProperty(t, field);
                long value = this.gtFilter.getValue();
                if (beanProperty instanceof Number) {
                    Number fieldValue = (Number)beanProperty;
                    return fieldValue.longValue() > value;
                }
                throw new RuntimeException("Gt,Gte,Lt and Lte filters only support numbers, provided field is not compatible: " + field);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return false;
            }
        }
    }

    public static class LtePojoFilter<T>
    implements PojoFilter<T> {
        private final Filters.Lte lteFilter;

        public LtePojoFilter(Filters.Lte lteFilter) {
            this.lteFilter = lteFilter;
        }

        @Override
        public boolean test(T t) {
            try {
                String field = this.lteFilter.getField();
                Object beanProperty = PojoFilters.getBeanProperty(t, field);
                long value = this.lteFilter.getValue();
                if (beanProperty instanceof Number) {
                    Number fieldValue = (Number)beanProperty;
                    return fieldValue.longValue() <= value;
                }
                throw new RuntimeException("Gt,Gte,Lt and Lte filters only support numbers, provided field is not compatible: " + field);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return false;
            }
        }
    }

    public static class LtPojoFilter<T>
    implements PojoFilter<T> {
        private final Filters.Lt ltFilter;

        public LtPojoFilter(Filters.Lt ltFilter) {
            this.ltFilter = ltFilter;
        }

        @Override
        public boolean test(T t) {
            try {
                String field = this.ltFilter.getField();
                Object beanProperty = PojoFilters.getBeanProperty(t, field);
                long value = this.ltFilter.getValue();
                if (beanProperty instanceof Number) {
                    Number fieldValue = (Number)beanProperty;
                    return fieldValue.longValue() < value;
                }
                throw new RuntimeException("Gt,Gte,Lt and Lte filters only support numbers, provided field is not compatible: " + field);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return false;
            }
        }
    }

    public static class RegexPojoFilter<T>
    implements PojoFilter<T> {
        private final Filters.Regex regexFilter;
        private final Pattern pattern;

        public RegexPojoFilter(Filters.Regex regexFilter) {
            this.regexFilter = regexFilter;
            Object expression = "";
            if (!regexFilter.isCaseSensitive()) {
                expression = (String)expression + "(?i)";
            }
            expression = (String)expression + regexFilter.getExpression();
            this.pattern = Pattern.compile((String)expression);
        }

        @Override
        public boolean test(T t) {
            try {
                Object beanProperty = PojoFilters.getBeanProperty(t, this.regexFilter.getField());
                if (beanProperty != null) {
                    Matcher matcher = this.pattern.matcher(beanProperty.toString());
                    return matcher.find();
                }
                return false;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return false;
            }
        }
    }

    public static class EqualsPojoFilter<T>
    implements PojoFilter<T> {
        private final Filters.Equals equalsFilter;
        private final Object expectedValue;

        public EqualsPojoFilter(Filters.Equals equalsFilter) {
            this.equalsFilter = equalsFilter;
            String field = equalsFilter.getField();
            Object expectedValue = equalsFilter.getExpectedValue();
            this.expectedValue = field.equals("id") && expectedValue instanceof String ? new ObjectId((String)expectedValue) : expectedValue;
        }

        @Override
        public boolean test(T t) {
            try {
                String field = this.equalsFilter.getField();
                Object beanProperty = PojoFilters.getBeanProperty(t, field);
                if (this.expectedValue != null) {
                    if (this.expectedValue instanceof Number) {
                        if (beanProperty != null) {
                            return new BigDecimal(this.expectedValue.toString()).compareTo(new BigDecimal(beanProperty.toString())) == 0;
                        }
                        return false;
                    }
                    return this.expectedValue.equals(beanProperty);
                }
                return beanProperty == null;
            }
            catch (NoSuchMethodException e) {
                return this.expectedValue == null;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return false;
            }
        }
    }

    public static class FalsePojoFilter<T>
    implements PojoFilter<T> {
        @Override
        public boolean test(T t) {
            return false;
        }
    }

    public static class TruePojoFilter<T>
    implements PojoFilter<T> {
        @Override
        public boolean test(T t) {
            return true;
        }
    }

    public static class NotPojoFilter<T>
    implements PojoFilter<T> {
        private final PojoFilter<T> pojoFilter;

        public NotPojoFilter(PojoFilter<T> PojoFilter2) {
            this.pojoFilter = PojoFilter2;
        }

        @Override
        public boolean test(T t) {
            return !this.pojoFilter.test(t);
        }
    }

    public static class OrPojoFilter<T>
    implements PojoFilter<T> {
        private final List<PojoFilter<T>> pojoFilters;

        public OrPojoFilter(List<PojoFilter<T>> PojoFilters2) {
            this.pojoFilters = PojoFilters2;
        }

        @Override
        public boolean test(T t) {
            return this.pojoFilters.stream().anyMatch(PojoFilter2 -> PojoFilter2.test(t));
        }
    }

    public static class AndPojoFilter<T>
    implements PojoFilter<T> {
        private final List<PojoFilter<T>> pojoFilters;

        public AndPojoFilter(List<PojoFilter<T>> PojoFilters2) {
            this.pojoFilters = PojoFilters2;
        }

        @Override
        public boolean test(T t) {
            return this.pojoFilters.stream().allMatch(PojoFilter2 -> PojoFilter2.test(t));
        }
    }

    public static class PojoFilterFactory<POJO>
    implements Filters.FilterFactory<PojoFilter<?>> {
        @Override
        public PojoFilter<POJO> buildFilter(Filter filter) {
            List<Filter> children = filter.getChildren();
            List childerPojoFilters = children != null ? children.stream().map(f -> this.buildFilter((Filter)f)).collect(Collectors.toList()) : null;
            if (filter instanceof Filters.And) {
                return new AndPojoFilter(childerPojoFilters);
            }
            if (filter instanceof Filters.Or) {
                return new OrPojoFilter(childerPojoFilters);
            }
            if (filter instanceof Filters.Not) {
                return new NotPojoFilter(childerPojoFilters.get(0));
            }
            if (filter instanceof Filters.Or) {
                return new OrPojoFilter(childerPojoFilters);
            }
            if (filter instanceof Filters.Equals) {
                return new EqualsPojoFilter((Filters.Equals)filter);
            }
            if (filter instanceof Filters.Regex) {
                return new RegexPojoFilter((Filters.Regex)filter);
            }
            if (filter instanceof Filters.True) {
                return new TruePojoFilter();
            }
            if (filter instanceof Filters.False) {
                return new FalsePojoFilter();
            }
            if (filter instanceof Filters.Lt) {
                return new LtPojoFilter((Filters.Lt)filter);
            }
            if (filter instanceof Filters.Lte) {
                return new LtePojoFilter((Filters.Lte)filter);
            }
            if (filter instanceof Filters.Gt) {
                return new GtPojoFilter((Filters.Gt)filter);
            }
            if (filter instanceof Filters.Gte) {
                return new GtePojoFilter((Filters.Gte)filter);
            }
            throw new IllegalArgumentException("Unsupported filter type " + filter.getClass());
        }
    }
}

