/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.api.material.packagerepository;

import com.thoughtworks.go.plugin.api.material.packagerepository.exceptions.InvalidPackageRevisionDataException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public class PackageRevision {
    private static Pattern DATA_KEY_PATTERN = Pattern.compile("[a-zA-Z0-9_]*");
    private static final String DATA_KEY_EMPTY_MESSAGE = "Key names cannot be null or empty.";
    private String revision;
    private Date timestamp;
    private String user;
    private String revisionComment;
    private String trackbackUrl;
    private Map<String, String> data;

    public PackageRevision(String revision, Date timestamp, String user) {
        this(revision, timestamp, user, new HashMap<String, String>());
    }

    public PackageRevision(String revision, Date timestamp, String user, Map<String, String> data) {
        this(revision, timestamp, user, null, null, data);
    }

    public PackageRevision(String revision, Date timestamp, String user, String revisionComment, String trackbackUrl) {
        this(revision, timestamp, user, revisionComment, trackbackUrl, new HashMap<String, String>());
    }

    public PackageRevision(String revision, Date timestamp, String user, String revisionComment, String trackbackUrl, Map<String, String> data) {
        this.revision = revision;
        this.timestamp = timestamp;
        this.user = user;
        this.revisionComment = revisionComment;
        this.trackbackUrl = trackbackUrl;
        this.validateDataKeys(data);
        this.data = data;
    }

    private void validateDataKeys(Map<String, String> data) {
        if (data != null) {
            for (String key : data.keySet()) {
                this.validateDataKey(key);
            }
        }
    }

    public String getRevision() {
        return this.revision;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getUser() {
        return this.user;
    }

    public String getRevisionComment() {
        return this.revisionComment;
    }

    public String getTrackbackUrl() {
        return this.trackbackUrl;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public String getDataFor(String key) {
        return this.data.get(key);
    }

    public void addData(String key, String value) throws InvalidPackageRevisionDataException {
        this.validateDataKey(key);
        this.data.put(key, value);
    }

    public void validateDataKey(String key) throws InvalidPackageRevisionDataException {
        if (key == null || key.isEmpty()) {
            throw new InvalidPackageRevisionDataException(DATA_KEY_EMPTY_MESSAGE);
        }
        Matcher matcher = DATA_KEY_PATTERN.matcher(key);
        if (!matcher.matches()) {
            throw new InvalidPackageRevisionDataException(this.dataKeyInvalidMessage(key));
        }
    }

    private String dataKeyInvalidMessage(String key) {
        return String.format("Key '%s' is invalid. Key names should consists of only alphanumeric characters and/or underscores.", key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageRevision that = (PackageRevision)o;
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        if (this.timestamp != null ? !this.timestamp.equals(that.timestamp) : that.timestamp != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        int result = this.revision != null ? this.revision.hashCode() : 0;
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PackageRevision{revision='" + this.revision + "', timestamp=" + this.timestamp + ", user='" + this.user + "', revisionComment='" + this.revisionComment + "', trackbackUrl='" + this.trackbackUrl + "', data=" + this.data + "}";
    }
}

