/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.util;

import android.graphics.Rect;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.view.TouchDelegate;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import cc.livvy.framework.util.StringUtils;

public class ViewUtils {
    public static <V extends View> V setGone(V view, boolean gone) {
        if (view != null) {
            if (gone) {
                if (8 != view.getVisibility()) {
                    view.setVisibility(8);
                }
            } else if (0 != view.getVisibility()) {
                view.setVisibility(0);
            }
        }
        return view;
    }

    public static <V extends View> V setInvisible(V view, boolean invisible) {
        if (view != null) {
            if (invisible) {
                if (4 != view.getVisibility()) {
                    view.setVisibility(4);
                }
            } else if (0 != view.getVisibility()) {
                view.setVisibility(0);
            }
        }
        return view;
    }

    public static void increaseHitRectBy(int amount, View delegate) {
        ViewUtils.increaseHitRectBy(amount, amount, amount, amount, delegate);
    }

    public static void increaseHitRectBy(final int top, final int left, final int bottom, final int right, final View delegate) {
        final View parent = (View)delegate.getParent();
        if (parent != null && delegate.getContext() != null) {
            parent.post(new Runnable(){

                @Override
                public void run() {
                    float densityDpi = delegate.getContext().getResources().getDisplayMetrics().densityDpi;
                    Rect r = new Rect();
                    delegate.getHitRect(r);
                    r.top -= ViewUtils.transformToDensityPixel(top, densityDpi);
                    r.left -= ViewUtils.transformToDensityPixel(left, densityDpi);
                    r.bottom += ViewUtils.transformToDensityPixel(bottom, densityDpi);
                    r.right += ViewUtils.transformToDensityPixel(right, densityDpi);
                    parent.setTouchDelegate(new TouchDelegate(r, delegate));
                }
            });
        }
    }

    public static int transformToDensityPixel(int regularPixel, DisplayMetrics displayMetrics) {
        return ViewUtils.transformToDensityPixel(regularPixel, displayMetrics.densityDpi);
    }

    public static int transformToDensityPixel(int regularPixel, float densityDpi) {
        return (int)((float)regularPixel * densityDpi);
    }

    public static boolean checkBtnEnable(EditText ... editTexts) {
        boolean enable = true;
        for (EditText each : editTexts) {
            if (!StringUtils.isBlank(each.getText())) continue;
            enable = false;
            break;
        }
        return enable;
    }

    public static void checkNotBlank(final Button button, final EditText ... editTexts) {
        TextWatcher notBlank = new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                if (ViewUtils.checkBtnEnable(editTexts)) {
                    button.setEnabled(true);
                } else {
                    button.setEnabled(false);
                }
            }

            public void afterTextChanged(Editable editable) {
            }
        };
        for (EditText each : editTexts) {
            each.addTextChangedListener(notBlank);
        }
    }
}

