/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.handler;

import android.os.Looper;
import cc.livvy.framework.handler.HandlerPoster;
import cc.livvy.framework.handler.SyncPost;

public class ThreadToolKit {
    private static HandlerPoster mainPoster = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HandlerPoster getMainPoster() {
        if (mainPoster != null) return mainPoster;
        Class<ThreadToolKit> clazz = ThreadToolKit.class;
        synchronized (ThreadToolKit.class) {
            if (mainPoster != null) return mainPoster;
            mainPoster = new HandlerPoster(Looper.getMainLooper(), 20);
            // ** MonitorExit[var0] (shouldn't be in output)
            return mainPoster;
        }
    }

    public static void runOnMainThreadAsync(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
            return;
        }
        ThreadToolKit.getMainPoster().async(runnable);
    }

    public static void runOnMainThreadSync(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
            return;
        }
        SyncPost poster = new SyncPost(runnable);
        ThreadToolKit.getMainPoster().sync(poster);
        poster.waitRun();
    }

    public static void dispose() {
        if (mainPoster != null) {
            mainPoster.dispose();
            mainPoster = null;
        }
    }
}

