/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.adapter;

import android.view.View;
import cc.livvy.framework.adapter.ItemViewHolder;
import cc.livvy.framework.adapter.LayoutIdMissingException;
import cc.livvy.framework.adapter.annotations.ClassAnnotationParser;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class EasyAdapterUtil {
    public static ItemViewHolder createViewHolder(View view, Class<? extends ItemViewHolder> itemViewHolderClass) {
        try {
            Constructor<? extends ItemViewHolder> constructor = itemViewHolderClass.getConstructor(View.class);
            return constructor.newInstance(view);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find a public constructor that takes an argument View in " + itemViewHolderClass.getSimpleName(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate " + itemViewHolderClass.getSimpleName(), e);
        }
    }

    public static Integer parseItemLayoutId(Class<? extends ItemViewHolder> itemViewHolderClass) {
        Integer itemLayoutId = ClassAnnotationParser.getLayoutId(itemViewHolderClass);
        if (itemLayoutId == null) {
            throw new LayoutIdMissingException();
        }
        return itemLayoutId;
    }
}

