/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.adapter;

import android.content.Context;
import cc.livvy.framework.adapter.BaseEasyAdapter;
import cc.livvy.framework.adapter.ItemViewHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EasyAdapter<T>
extends BaseEasyAdapter<T> {
    private List<T> mListItems;

    public EasyAdapter(Context context, Class<? extends ItemViewHolder> itemViewHolderClass, List<T> listItems) {
        super(context, itemViewHolderClass);
        this.setItems(listItems);
    }

    public EasyAdapter(Context context, Class<? extends ItemViewHolder> itemViewHolderClass) {
        super(context, itemViewHolderClass);
        this.mListItems = new ArrayList<T>();
    }

    public EasyAdapter(Context context, Class<? extends ItemViewHolder> itemViewHolderClass, List<T> listItems, Object listener) {
        super(context, itemViewHolderClass, listener);
        this.setItems(listItems);
    }

    public EasyAdapter(Context context, Class<? extends ItemViewHolder> itemViewHolderClass, Object listener) {
        super(context, itemViewHolderClass, listener);
        this.mListItems = new ArrayList<T>();
    }

    public void setItems(List<T> listItems) {
        this.mListItems = listItems;
        this.notifyDataSetChanged();
    }

    public void setItemsWithoutNotifying(List<T> listItems) {
        this.mListItems = listItems;
    }

    public List<T> getItems() {
        return this.mListItems;
    }

    public void addItem(T item) {
        this.mListItems.add(item);
        this.notifyDataSetChanged();
    }

    public boolean removeItem(T item) {
        if (this.mListItems.remove(item)) {
            this.notifyDataSetChanged();
            return true;
        }
        return false;
    }

    public boolean addItems(Collection<? extends T> items) {
        if (this.mListItems.addAll(items)) {
            this.notifyDataSetChanged();
            return true;
        }
        return false;
    }

    public boolean removeItems(Collection<? extends T> items) {
        if (this.mListItems.removeAll(items)) {
            this.notifyDataSetChanged();
            return true;
        }
        return false;
    }

    public int getCount() {
        return this.mListItems.size();
    }

    public long getItemId(int position) {
        return position;
    }

    @Override
    public T getItem(int position) {
        return this.mListItems.get(position);
    }
}

